/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageContainerMenu
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    private final StorageBlockEntity storageBlockEntity;

    public StorageContainerMenu(int containerId, Player player, BlockPos pos) {
        this((MenuType)ModBlocks.STORAGE_CONTAINER_TYPE.get(), containerId, player, pos);
    }

    public StorageContainerMenu(MenuType<?> menuType, int containerId, Player player, BlockPos pos) {
        super(menuType, containerId, player, StorageContainerMenu.getWrapper(player.f_19853_, pos), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false);
        this.storageBlockEntity = (StorageBlockEntity)WorldHelper.getBlockEntity((BlockGetter)player.f_19853_, (BlockPos)pos, StorageBlockEntity.class).orElseThrow(() -> new IllegalArgumentException("Incorrect block entity at " + pos + " exptected to find StorageBlockEntity"));
        this.storageBlockEntity.startOpen(player);
    }

    public StorageBlockEntity getStorageBlockEntity() {
        return this.storageBlockEntity;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.storageBlockEntity.stopOpen(player);
    }

    private static IStorageWrapper getWrapper(Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> be.getStorageWrapper()).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
    }

    public static StorageContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        return new StorageContainerMenu(windowId, playerInventory.f_35978_, packetBuffer.m_130135_());
    }

    public Optional<BlockPos> getBlockPosition() {
        return Optional.of(this.storageBlockEntity.m_58899_());
    }

    protected StorageContainerMenuBase.StorageUpgradeSlot instantiateUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
        return new StorageContainerMenuBase.StorageUpgradeSlot(upgradeHandler, slotIndex){

            protected void onUpgradeChanged() {
                if (StorageContainerMenu.this.player.m_9236_().m_5776_()) {
                    return;
                }
                ((ItemDisplaySettingsCategory)StorageContainerMenu.this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }
        };
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.m_128359_("action", "openSettings"));
            return;
        }
        this.getBlockPosition().ifPresent(pos -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)this.player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, (BlockPos)pos), (Component)Component.m_237115_((String)StorageTranslationHelper.INSTANCE.translGui("settings.title"))), (BlockPos)this.storageBlockEntity.m_58899_()));
    }

    protected StorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, Player player, BlockPos pos) {
        return new StorageSettingsContainerMenu(windowId, player, pos);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        return false;
    }

    public boolean m_6875_(Player player) {
        WoodStorageBlockEntity woodStorageBlockEntity;
        BlockPos pos = this.storageBlockEntity.m_58899_();
        BlockEntity be = player.f_19853_.m_7702_(pos);
        return be instanceof StorageBlockEntity && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0 && (!(be instanceof WoodStorageBlockEntity) || !(woodStorageBlockEntity = (WoodStorageBlockEntity)be).isPacked());
    }

    protected void onStorageInventorySlotSet(int slotIndex) {
        MemorySettingsCategory memorySettings;
        super.onStorageInventorySlotSet(slotIndex);
        if (this.getStorageBlockEntity().isLocked() && this.getStorageBlockEntity().memorizesItemsWhenLocked() && !this.m_38853_(slotIndex).m_7993_().m_41619_() && !(memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).isSlotSelected(slotIndex)) {
            memorySettings.selectSlot(slotIndex);
        }
    }
}

