/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.properties;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.InventoryStream;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.properties.IToolProvider;

@ParametersAreNonnullByDefault
public class PropertyHelper {
    public static int getItemToolLevel(ItemStack itemStack, ToolAction tool) {
        return Optional.of(itemStack).filter(stack -> !stack.m_41619_()).map(PropertyHelper::getReplacement).filter(stack -> stack.m_41720_() instanceof IToolProvider).map(stack -> ((IToolProvider)stack.m_41720_()).getToolLevel((ItemStack)stack, tool)).orElse(0);
    }

    public static Set<ToolAction> getItemTools(ItemStack itemStack) {
        return Optional.of(itemStack).filter(stack -> !stack.m_41619_()).map(PropertyHelper::getReplacement).filter(stack -> stack.m_41720_() instanceof IToolProvider).map(stack -> ((IToolProvider)stack.m_41720_()).getTools((ItemStack)stack)).orElse(Collections.emptySet());
    }

    public static int getPlayerEffectLevel(Player player, ItemEffect effect) {
        return Stream.concat(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).map(itemStack -> ((IModularItem)itemStack.m_41720_()).getEffectLevel((ItemStack)itemStack, effect)).max(Integer::compare).orElse(0);
    }

    public static float getPlayerEffectEfficiency(Player player, ItemEffect effect) {
        return Stream.concat(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IModularItem).max(Comparator.comparingInt(itemStack -> ((IModularItem)itemStack.m_41720_()).getEffectLevel((ItemStack)itemStack, effect))).map(itemStack -> Float.valueOf(((IModularItem)itemStack.m_41720_()).getEffectEfficiency((ItemStack)itemStack, effect))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static int getPlayerToolLevel(Player player, ToolAction tool) {
        return Stream.concat(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevel((ItemStack)itemStack, tool)).max(Integer::compare).orElse(0);
    }

    public static Set<ToolAction> getPlayerTools(Player player) {
        return Stream.concat(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).flatMap(itemStack -> ((IToolProvider)itemStack.m_41720_()).getTools((ItemStack)itemStack).stream()).collect(Collectors.toSet());
    }

    public static Map<ToolAction, Integer> getPlayerToolLevels(Player player) {
        return Stream.concat(player.m_150109_().f_35976_.stream(), player.m_150109_().f_35974_.stream()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevels((ItemStack)itemStack)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    public static int getInventoryToolLevel(Container inventory, ToolAction tool) {
        int result = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            int comparisonLevel = result;
            result = Optional.of(inventory.m_8020_(i)).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevel((ItemStack)itemStack, tool)).filter(level -> level > comparisonLevel).orElse(comparisonLevel);
        }
        return result;
    }

    public static Set<ToolAction> getInventoryTools(Container inventory) {
        HashSet<ToolAction> result = new HashSet<ToolAction>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            Optional.of(inventory.m_8020_(i)).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.m_41720_()).getTools((ItemStack)itemStack).stream()).orElseGet(Stream::empty).forEach(result::add);
        }
        return result;
    }

    public static Map<ToolAction, Integer> getInventoryToolLevels(Container inventory) {
        return InventoryStream.of((Container)inventory).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevels((ItemStack)itemStack)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    public static ItemStack getInventoryProvidingItemStack(Container inventory, ToolAction tool, int level) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack result = Optional.of(inventory.m_8020_(i)).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).filter(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevel((ItemStack)itemStack, tool) >= level).orElse(ItemStack.f_41583_);
            if (result.m_41619_()) continue;
            return result;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getPlayerProvidingItemStack(ToolAction tool, int level, Entity entity) {
        return CastOptional.cast((Object)entity, Player.class).map(player -> Stream.concat(Stream.of(player.m_21205_(), player.m_21206_()), player.m_150109_().f_35974_.stream())).orElse(Stream.empty()).filter(itemStack -> !itemStack.m_41619_()).map(PropertyHelper::getReplacement).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).filter(itemStack -> ((IToolProvider)itemStack.m_41720_()).getToolLevel((ItemStack)itemStack, tool) >= level).findAny().orElse(ItemStack.f_41583_);
    }

    public static ItemStack consumeCraftToolInventory(Container inventory, Player player, ItemStack targetStack, ToolAction tool, int level, boolean consumeResources) {
        ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(inventory, tool, level);
        if (itemStack.m_41720_() instanceof IToolProvider) {
            return ((IToolProvider)itemStack.m_41720_()).onCraftConsume(itemStack, targetStack, player, tool, level, consumeResources);
        }
        return null;
    }

    public static ItemStack consumeActionToolInventory(Container inventory, Player player, ItemStack targetStack, ToolAction tool, int level, boolean consumeResources) {
        ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(inventory, tool, level);
        if (itemStack.m_41720_() instanceof IToolProvider) {
            return ((IToolProvider)itemStack.m_41720_()).onActionConsume(itemStack, targetStack, player, tool, level, consumeResources);
        }
        return null;
    }

    private static ItemStack getReplacement(ItemStack itemStack) {
        ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(itemStack);
        if (!replacement.m_41619_()) {
            return replacement;
        }
        return itemStack;
    }

    public static int getBlockToolLevel(Level world, BlockPos pos, BlockState blockStateIn, ToolAction tool) {
        return Optional.of(blockStateIn).map(BlockBehaviour.BlockStateBase::m_60734_).flatMap(block -> CastOptional.cast((Object)block, AbstractWorkbenchBlock.class)).map(block -> block.getToolLevel(world, pos, blockStateIn, tool)).orElse(0);
    }

    public static Collection<ToolAction> getBlockTools(Level world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).map(BlockBehaviour.BlockStateBase::m_60734_).flatMap(block -> CastOptional.cast((Object)block, AbstractWorkbenchBlock.class)).map(block -> block.getTools(world, pos, blockStateIn)).orElse(Collections.emptyList());
    }

    public static Map<ToolAction, Integer> getBlockToolLevels(Level world, BlockPos pos, BlockState blockStateIn) {
        return Optional.of(blockStateIn).map(BlockBehaviour.BlockStateBase::m_60734_).flatMap(block -> CastOptional.cast((Object)block, AbstractWorkbenchBlock.class)).map(block -> block.getToolLevels(world, pos, blockStateIn)).orElse(Collections.emptyMap());
    }

    public static int getToolbeltToolLevel(Player player, ToolAction tool) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> Math.max(PropertyHelper.getInventoryToolLevel(new QuickslotInventory((ItemStack)toolbeltStack), tool), PropertyHelper.getInventoryToolLevel(new StorageInventory((ItemStack)toolbeltStack), tool))).orElse(0);
    }

    public static Set<ToolAction> getToolbeltTools(Player player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> Sets.union(PropertyHelper.getInventoryTools(new QuickslotInventory((ItemStack)toolbeltStack)), PropertyHelper.getInventoryTools(new StorageInventory((ItemStack)toolbeltStack)))).orElse(Collections.emptySet());
    }

    public static Map<ToolAction, Integer> getToolbeltToolLevels(Player player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> Stream.of(PropertyHelper.getInventoryToolLevels(new QuickslotInventory((ItemStack)toolbeltStack)), PropertyHelper.getInventoryToolLevels(new StorageInventory((ItemStack)toolbeltStack)))).orElseGet(Stream::empty).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }

    @Nullable
    public static ItemStack consumeCraftToolToolbelt(Player player, ItemStack targetStack, ToolAction tool, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = PropertyHelper.consumeCraftToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                quickslotInventory.m_6596_();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = PropertyHelper.consumeCraftToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                storageInventory.m_6596_();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack consumeActionToolToolbelt(Player player, ItemStack targetStack, ToolAction tool, int level, boolean consumeResources) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(toolbeltStack -> !toolbeltStack.m_41619_()).map(toolbeltStack -> {
            QuickslotInventory quickslotInventory = new QuickslotInventory((ItemStack)toolbeltStack);
            ItemStack result = PropertyHelper.consumeActionToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                quickslotInventory.m_6596_();
                return result;
            }
            StorageInventory storageInventory = new StorageInventory((ItemStack)toolbeltStack);
            result = PropertyHelper.consumeActionToolInventory(quickslotInventory, player, targetStack, tool, level, consumeResources);
            if (result != null) {
                storageInventory.m_6596_();
                return result;
            }
            return null;
        }).orElse(null);
    }

    public static ItemStack getToolbeltProvidingItemStack(ToolAction tool, int level, Player player) {
        return Optional.of(ToolbeltHelper.findToolbelt(player)).filter(itemStack -> !itemStack.m_41619_()).map(toolbeltStack -> {
            ItemStack itemStack = PropertyHelper.getInventoryProvidingItemStack(new QuickslotInventory((ItemStack)toolbeltStack), tool, level);
            if (!itemStack.m_41619_()) {
                return itemStack;
            }
            return PropertyHelper.getInventoryProvidingItemStack(new StorageInventory((ItemStack)toolbeltStack), tool, level);
        }).orElse(ItemStack.f_41583_);
    }

    public static int getCombinedToolLevel(Player player, Level world, BlockPos pos, BlockState blockStateIn, ToolAction tool) {
        return IntStream.of(PropertyHelper.getPlayerToolLevel(player, tool), PropertyHelper.getToolbeltToolLevel(player, tool), PropertyHelper.getBlockToolLevel(world, pos, blockStateIn, tool)).max().orElse(0);
    }

    public static Map<ToolAction, Integer> getCombinedToolLevels(Player player, Level world, BlockPos pos, BlockState blockStateIn) {
        return Stream.of(PropertyHelper.getInventoryToolLevels((Container)player.m_150109_()), PropertyHelper.getToolbeltToolLevels(player), PropertyHelper.getBlockToolLevels(world, pos, blockStateIn)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Math::max));
    }
}

