/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay;

import javax.annotation.ParametersAreNonnullByDefault;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class QuickslotDirectionGui
extends GuiElement {
    private final GuiTexture arrow;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;

    public QuickslotDirectionGui(int x, int y, int width, int height, boolean right) {
        super(x, y, width, height);
        if (right) {
            this.arrow = new GuiTexture(7, -1, 5, 7, 5, 42, GuiTextures.toolbelt);
            this.arrow.setAttachment(GuiAttachment.middleLeft);
        } else {
            this.arrow = new GuiTexture(-7, -1, 5, 7, 0, 42, GuiTextures.toolbelt);
            this.arrow.setAttachment(GuiAttachment.middleRight);
        }
        this.arrow.setColor(0x404040);
        this.arrow.setOpacity(0.0f);
        this.addChild((GuiElement)this.arrow);
        this.showAnimation = new KeyframeAnimation(100, (GuiElement)this.arrow).applyTo(new Applier[]{new Applier.TranslateX((float)(this.arrow.getX() + (right ? 1 : -1))), new Applier.Opacity(1.0f)});
        this.hideAnimation = new KeyframeAnimation(200, (GuiElement)this.arrow).applyTo(new Applier[]{new Applier.TranslateX((float)this.arrow.getX()), new Applier.Opacity(0.0f)});
    }

    public void animateIn() {
        this.hideAnimation.stop();
        this.showAnimation.start();
    }

    public void animateOut() {
        this.arrow.setColor(0x404040);
        this.showAnimation.stop();
        this.hideAnimation.start();
    }

    protected void onFocus() {
        this.arrow.setColor(0xFFFFCC);
    }

    protected void onBlur() {
        this.arrow.setColor(0x404040);
    }
}

