/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.PryEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class PryChargedEffect
extends ChargedAbilityEffect {
    public static final PryChargedEffect instance = new PryChargedEffect();

    PryChargedEffect() {
        super(20, 0.0, 40, 3.0, ItemEffect.pry, ChargedAbilityEffect.TargetRequirement.entity, UseAnim.SPEAR, "raised");
    }

    @Override
    public boolean isAvailable(ItemModularHandheld item, ItemStack itemStack) {
        return super.isAvailable(item, itemStack) && item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge) > 0;
    }

    @Override
    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        int revengeLevel;
        if (!target.f_19853_.f_46443_) {
            int amplifier = item.getEffectLevel(itemStack, ItemEffect.pry);
            double damageMultiplier = 0.5;
            int comboPoints = ComboPoints.get((Entity)attacker);
            boolean isSatiated = !attacker.m_36324_().m_38721_();
            AbilityUseResult result = PryEffect.performRegular(attacker, item, itemStack, damageMultiplier += (double)(this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0, amplifier += (int)((float)this.getOverchargeBonus(item, itemStack, chargedTicks) * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge)), target, isSatiated, comboPoints);
            item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
            int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
            if (echoLevel > 0) {
                PryEffect.performEcho(attacker, item, itemStack, damageMultiplier, amplifier, target, isSatiated, comboPoints);
            }
        }
        attacker.m_36399_(1.0f);
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if ((revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge)) > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }
}

