/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class CritEffect {
    private static final Cache<UUID, BlockPos> critBlockCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public static boolean critBlock(Level world, Player breakingPlayer, BlockPos pos, BlockState blockState, ItemStack itemStack, int critLevel) {
        BlockPos recentCritPos = (BlockPos)critBlockCache.getIfPresent((Object)breakingPlayer.m_20148_());
        if (pos.equals((Object)recentCritPos)) {
            return true;
        }
        if ((double)breakingPlayer.m_217043_().m_188501_() < (double)critLevel * 0.01 && recentCritPos == null && blockState.m_60800_((BlockGetter)world, pos) > -1.0f && itemStack.m_41720_().m_8102_(itemStack, blockState) > 2.0f * blockState.m_60800_((BlockGetter)world, pos) && ToolActionHelper.playerCanDestroyBlock(breakingPlayer, blockState, pos, itemStack)) {
            EffectHelper.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
            itemStack.m_41720_().m_6813_(itemStack, world, blockState, pos, (LivingEntity)breakingPlayer);
            critBlockCache.put((Object)breakingPlayer.m_20148_(), (Object)pos);
            CastOptional.cast((Object)breakingPlayer, ServerPlayer.class).ifPresent(serverPlayer -> EffectHelper.sendEventToPlayer(serverPlayer, 2001, pos, Block.m_49956_((BlockState)blockState)));
            if (world instanceof ServerLevel) {
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 12, (world.f_46441_.m_188500_() * 2.0 - 1.0) * 0.3, 0.3 + world.f_46441_.m_188500_() * 0.3, (world.f_46441_.m_188500_() * 2.0 - 1.0) * 0.3, 0.3);
            }
            return true;
        }
        return false;
    }

    public static void onBlockBreak(LivingEntity entity) {
        critBlockCache.invalidate((Object)entity.m_20148_());
    }

    public static void critEntity(CriticalHitEvent event, ItemStack itemStack, int critLevel) {
        if ((double)event.getEntity().m_217043_().m_188501_() < (double)critLevel * 0.01) {
            event.setDamageModifier(Math.max(EffectHelper.getEffectEfficiency(itemStack, ItemEffect.criticalStrike), event.getDamageModifier()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static double rollMultiplier(RandomSource random, IModularItem item, ItemStack itemStack) {
        int critLevel = item.getEffectLevel(itemStack, ItemEffect.criticalStrike);
        if (critLevel > 0 && (double)random.m_188501_() < (double)critLevel * 0.01) {
            return item.getEffectEfficiency(itemStack, ItemEffect.criticalStrike);
        }
        return 1.0;
    }
}

