/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;

public class SyncEmptySlotIconsMessage {
    private final Map<ResourceLocation, Set<Integer>> emptySlotIcons;

    public SyncEmptySlotIconsMessage(Map<ResourceLocation, Set<Integer>> emptySlotIcons) {
        this.emptySlotIcons = emptySlotIcons;
    }

    public static void encode(SyncEmptySlotIconsMessage msg, FriendlyByteBuf packetBuffer) {
        SyncEmptySlotIconsMessage.writeEmptySlotTextures(packetBuffer, msg.emptySlotIcons);
    }

    public static void writeEmptySlotTextures(FriendlyByteBuf buffer, Map<ResourceLocation, Set<Integer>> map) {
        buffer.writeInt(map.size());
        for (Map.Entry<ResourceLocation, Set<Integer>> entry : map.entrySet()) {
            buffer.m_130085_(entry.getKey());
            buffer.m_130089_(entry.getValue().stream().mapToInt(i -> i).toArray());
        }
    }

    public static SyncEmptySlotIconsMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncEmptySlotIconsMessage(SyncEmptySlotIconsMessage.readEmptySlotTextures(packetBuffer));
    }

    public static Map<ResourceLocation, Set<Integer>> readEmptySlotTextures(FriendlyByteBuf buffer) {
        HashMap<ResourceLocation, Set<Integer>> map = new HashMap<ResourceLocation, Set<Integer>>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation resourceLocation = buffer.m_130281_();
            map.put(resourceLocation, Arrays.stream(buffer.m_130100_()).boxed().collect(Collectors.toSet()));
        }
        return map;
    }

    public static void onMessage(SyncEmptySlotIconsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncEmptySlotIconsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncEmptySlotIconsMessage msg) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof IAdditionalSlotInfoMenu)) {
            return;
        }
        IAdditionalSlotInfoMenu menu = (IAdditionalSlotInfoMenu)abstractContainerMenu;
        menu.updateEmptySlotIcons(msg.emptySlotIcons);
    }
}

