/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.api.math.IMatrix3f;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.math.IQuaternionf;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PoseStackWrapper
implements IPoseStack {
    private PoseStack stack;

    public PoseStackWrapper(PoseStack poseStack) {
        this.stack = poseStack;
    }

    public static PoseStack of(IPoseStack poseStack) {
        if (poseStack instanceof PoseStackWrapper) {
            return ((PoseStackWrapper)poseStack).pose();
        }
        PoseStack poseStack1 = new PoseStack();
        ABI.mulPoseMatrix(poseStack1, poseStack.lastPose());
        ABI.mulNormalMatrix(poseStack1, poseStack.lastNormal());
        return poseStack1;
    }

    @Override
    public void pushPose() {
        this.stack.m_85836_();
    }

    @Override
    public void popPose() {
        this.stack.m_85849_();
    }

    @Override
    public void translate(float x, float y, float z) {
        this.stack.m_85837_((double)x, (double)y, (double)z);
    }

    @Override
    public void scale(float x, float y, float z) {
        this.stack.m_85841_(x, y, z);
    }

    @Override
    public void rotate(IQuaternionf quaternion) {
        ABI.mulPose(this.stack, quaternion);
    }

    @Override
    public void multiply(IMatrix3f matrix) {
        ABI.mulNormalMatrix(this.stack, matrix);
    }

    @Override
    public void multiply(IMatrix4f matrix) {
        ABI.mulPoseMatrix(this.stack, matrix);
    }

    @Override
    public IMatrix4f lastPose() {
        return ABI.lastPose(this.stack);
    }

    @Override
    public IMatrix3f lastNormal() {
        return ABI.lastNormal(this.stack);
    }

    public void set(PoseStack poseStack) {
        this.stack = poseStack;
    }

    public PoseStack pose() {
        return this.stack;
    }
}

