/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelBabyPose;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.model.Model.BabyPose;
import moe.plushie.armourers_workshop.core.client.model.CachedModel;
import moe.plushie.armourers_workshop.utils.ModelPartHolder;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelHolder {
    private static final HashMap<Class<?>, Entry<?, ?>> ENTRIES = new HashMap();

    public static <V extends Model, M extends IModel> M ofNullable(V model) {
        if (model != null) {
            return ModelHolder.of(model);
        }
        return null;
    }

    public static <M extends IModel> M of(Model model) {
        IAssociatedObjectProvider provider = ObjectUtils.safeCast(model, IAssociatedObjectProvider.class);
        if (provider != null) {
            IModel holder = (IModel)provider.getAssociatedObject();
            if (holder != null) {
                return (M)holder;
            }
            holder = ModelHolder.createHolder(model);
            provider.setAssociatedObject(holder);
            return (M)holder;
        }
        return ModelHolder.createHolder(model);
    }

    public static <T extends Model> void register(Class<T> clazz, BiConsumer<T, Container> builder) {
        ModelHolder.register(clazz, null, builder);
    }

    public static <T extends Model> void register(Class<T> clazz, Function<Container, IModel> factory, BiConsumer<T, Container> builder) {
        ENTRIES.put(clazz, new Entry<T, IModel>(clazz, factory, builder));
    }

    public static <T extends Model> void registerOptional(Class<T> clazz, Function<Container, IModel> factory, BiConsumer<T, Container> builder) {
        if (clazz != null) {
            ModelHolder.register(clazz, factory, builder);
        }
    }

    private static <V extends Model, M extends IModel> M createHolder(V model) {
        ArrayList<BiConsumer> builders = new ArrayList<BiConsumer>();
        Function factory = null;
        for (Class<?> clazz = model.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Entry<?, ?> entry = ENTRIES.get(clazz);
            if (entry == null) continue;
            Entry entry1 = (Entry)ObjectUtils.unsafeCast(entry);
            builders.add(entry1.builder);
            if (factory != null) continue;
            factory = entry1.factory;
        }
        if (factory == null) {
            Function<Container, CachedModel> factory1 = CachedModel::new;
            factory = (Function)ObjectUtils.unsafeCast(factory1);
        }
        Container container = new Container(model);
        builders.forEach(builder -> builder.accept(model, container));
        return (M)((IModel)factory.apply(container));
    }

    public static class Entry<T extends Model, M extends IModel> {
        Class<T> clazz;
        Function<Container, M> factory;
        BiConsumer<T, Container> builder;

        Entry(Class<T> clazz, Function<Container, M> factory, BiConsumer<T, Container> builder) {
            this.clazz = clazz;
            this.factory = factory;
            this.builder = builder;
        }
    }

    public static class Container
    extends CachedModel.Container<ModelPart> {
        private final EntityModel<?> model;

        public Container(Model model) {
            super(ModelPartHolder::of);
            this.model = ObjectUtils.safeCast(model, EntityModel.class);
            this.babyPose = BabyPose.getBabyPose(model);
        }

        @Override
        public IModelBabyPose getBabyPose() {
            if (this.model != null && this.model.f_102610_) {
                return super.getBabyPose();
            }
            return null;
        }
    }
}

