/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.uikit.UIColor;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.ItemStackStorage;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static UIColor[] PALETTE_MINECRAFT = ColorUtils.makePaletteColors(0xFFFFFF, 0xFFFF55, 0xFF55FF, 0xFF5555, 0x55FFFF, 0x55FF55, 0x5555FF, 0x555555, 0xAAAAAA, 0xFFAA00, 0xAA00AA, 0xAA0000, 43690, 43520, 170, 0, 0xDDDDDD, 14384446, 11751612, 7047881, 11642407, 4304440, 13665433, 0x404040, 0x9AA1A1, 3042953, 8273333, 3029133, 5190175, 3491355, 9843760, 0x191616);
    public static UIColor[] PALETTE_SHADES = new UIColor[0];
    public static UIColor[] PALETTE_WARM32 = ColorUtils.makePaletteColors(855582, 3092804, 6449779, 9741738, 13885409, 2693152, 6899529, 10841702, 13342320, 15521975, 2623789, 6892376, 8405089, 10572138, 14783379, 1973560, 5326185, 8681611, 12495039, 2305359, 3820397, 6650266, 10073309, 4285579, 7317955, 12182245, 13888216, 664357, 2113593, 4088392, 7835507, 11846568);
    public static UIColor[] PALETTE_PASTEL_64_A = ColorUtils.makePaletteColors(10060406, 0xC4C484, 11262083, 10678973, 0xB88488, 13742466, 13953937, 0xCCFCC4, 9467545, 12879012, 15371385, 15918498, 10126520, 13730506, 15438248, 16768452, 7769497, 0x8484C4, 12876266, 15901399, 0x84B8B4, 8561361, 10981867, 16500981, 8164730, 8701092, 7985130, 0xA2AFF2, 10664068, 8573321, 9563092, 13231610);
    public static UIColor[] PALETTE_PASTEL_64_B = ColorUtils.makePaletteColors(12101508, 12176009, 9563025, 13237481, 9795206, 12883076, 15392378, 12841634, 12092591, 13730447, 15449489, 16251332, 0x797699, 11830468, 15366587, 15903138, 8689080, 10322641, 15372779, 16763092, 7771533, 8697028, 7963370, 13738738, 8697997, 8573380, 9551595, 13813498, 0x969976, 9749636, 7989928, 10677234);
    public static UIColor[] PALETTE_SOFTMILK32 = ColorUtils.makePaletteColors(14244762, 10372241, 0x633662, 9452898, 12407130, 14064206, 15978560, 16771212, 0xF2F2F0, 9756818, 2070915, 2253675, 12937334, 6043713, 9721928, 13729643, 15441791, 15843983, 12170691, 7763069, 5723247, 2302269, 4538772, 4348861, 0x4884D4, 4563422, 8181995, 14873190, 12833858, 0x82AA28, 5865246, 3629353);
    public static UIColor[] PALETTE_ENDESGA_32 = ColorUtils.makePaletteColors(12470831, 14120515, 15389866, 14984818, 12087120, 7552569, 4073265, 10626611, 14957380, 16217634, 16690740, 16705377, 6539085, 4098376, 2513986, 1653822, 1199753, 39387, 2943221, 0xFFFFFF, 12635100, 9149364, 5925256, 3818598, 2501444, 1578021, 0xFF0044, 6830188, 11882632, 16151930, 15251350, 12748137);

    public static int makeColorBighter(int rgb, int amount) {
        int r = ColorUtils.getRed(rgb) + amount;
        int g = ColorUtils.getGreen(rgb) + amount;
        int b = ColorUtils.getBlue(rgb) + amount;
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int addColorNoise(int rgb, int amount, Random random) {
        int r = ColorUtils.getRed(rgb) - amount + random.nextInt(amount * 2);
        int g = ColorUtils.getGreen(rgb) - amount + random.nextInt(amount * 2);
        int b = ColorUtils.getBlue(rgb) - amount + random.nextInt(amount * 2);
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int addShadeNoise(int rgb, int amount, Random random) {
        int shadeAmount = random.nextInt(amount * 2);
        int r = ColorUtils.getRed(rgb) - amount + shadeAmount;
        int g = ColorUtils.getGreen(rgb) - amount + shadeAmount;
        int b = ColorUtils.getBlue(rgb) - amount + shadeAmount;
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        return ColorUtils.getRGB(r, g, b);
    }

    public static int getAverageColor(Iterable<Integer> colors) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int count = 0;
        for (int rgb : colors) {
            red += ColorUtils.getRed(rgb);
            green += ColorUtils.getGreen(rgb);
            blue += ColorUtils.getBlue(rgb);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        return ColorUtils.getRGB(red / count, green / count, blue / count);
    }

    public static UIColor[] makePaletteColors(int ... colors) {
        UIColor[] colors1 = new UIColor[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors1[i] = new UIColor(colors[i]);
        }
        return colors1;
    }

    public static UIColor getPaletteColor(int index) {
        return PALETTE_MINECRAFT[(index + 1) % PALETTE_MINECRAFT.length];
    }

    public static int getPaletteColor(int index, int type) {
        return type << 24 | ColorUtils.getPaletteColor(index).getRGB() & 0xFFFFFF;
    }

    public static int getRainbowRGB() {
        float f = (float)(System.currentTimeMillis() % 6375L) / 25.0f;
        return UIColor.HSBtoRGB(f / 255.0f, 1.0f, 1.0f);
    }

    public static int getPulse1Color(int color) {
        float f = (float)((double)System.currentTimeMillis() % 6375.0) / 25.0f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = MathUtils.clamp(f, 0.0f, 255.0f);
        float[] hsb = UIColor.RGBtoHSB(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), null);
        return UIColor.HSBtoRGB(hsb[0], hsb[1], f / 255.0f);
    }

    public static int getPulse2Color(int color) {
        float f = (float)((double)System.currentTimeMillis() % 3187.5) / 12.5f;
        if ((f *= 2.0f) > 255.0f) {
            f = 255.0f - (f - 255.0f);
        }
        f = MathUtils.clamp(f, 0.0f, 255.0f);
        float[] hsb = UIColor.RGBtoHSB(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), null);
        return UIColor.HSBtoRGB(hsb[0], hsb[1], f / 255.0f);
    }

    public static int getDisplayRGB(IPaintColor paintColor) {
        ISkinPaintType paintType = paintColor.getPaintType();
        if (paintType == SkinPaintTypes.RAINBOW) {
            return ColorUtils.getRainbowRGB();
        }
        if (paintType == SkinPaintTypes.PULSE_1) {
            return ColorUtils.getPulse1Color(paintColor.getRGB());
        }
        if (paintType == SkinPaintTypes.PULSE_2) {
            return ColorUtils.getPulse2Color(paintColor.getRGB());
        }
        return paintColor.getRGB();
    }

    public static int getDisplayRGB(ItemStack itemStack) {
        IPaintColor paintColor = ColorUtils.getColor(itemStack);
        if (paintColor != null) {
            return ColorUtils.getDisplayRGB(paintColor) | 0xFF000000;
        }
        return -1;
    }

    public static boolean hasColor(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null && tag.m_128425_("Color", 3);
    }

    public static void setColor(ItemStack itemStack, IPaintColor color) {
        OptionalAPI.putOptionalPaintColor(itemStack.m_41784_(), "Color", color, null);
    }

    @Nullable
    public static IPaintColor getColor(ItemStack itemStack) {
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        if (storage.paintColor != null) {
            return storage.paintColor.orElse(null);
        }
        IPaintColor paintColor = ColorUtils.getColor(itemStack, null);
        storage.paintColor = Optional.ofNullable(paintColor);
        return paintColor;
    }

    public static void setColor(ItemStack itemStack, @Nullable String rootPath, IPaintColor color) {
        CompoundTag tag = itemStack.m_41784_();
        if (rootPath != null) {
            if (tag.m_128441_(rootPath)) {
                tag = tag.m_128469_(rootPath);
            } else {
                CompoundTag newTag = new CompoundTag();
                tag.m_128365_(rootPath, (Tag)newTag);
                tag = newTag;
            }
        }
        OptionalAPI.putOptionalPaintColor(tag, "Color", color, null);
    }

    @Nullable
    public static IPaintColor getColor(ItemStack itemStack, @Nullable String rootPath) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && rootPath != null) {
            tag = tag.m_128469_(rootPath);
        }
        if (tag != null && tag.m_128441_("Color")) {
            Tag nbt = tag.m_128423_("Color");
            if (nbt instanceof NumericTag) {
                return PaintColor.of(((NumericTag)nbt).m_7047_());
            }
            if (nbt instanceof StringTag) {
                UIColor color = ColorUtils.parseColor(nbt.m_7916_());
                tag.m_128405_("Color", color.getRGB());
                return PaintColor.of(color.getRGB());
            }
            tag.m_128473_("Color");
        }
        return null;
    }

    @Nullable
    public static BlockPaintColor getBlockColor(ItemStack itemStack) {
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        if (storage.blockPaintColor != null) {
            return storage.blockPaintColor.orElse(null);
        }
        BlockPaintColor color = null;
        CompoundTag tag = itemStack.m_41737_("BlockEntityTag");
        if (tag != null) {
            color = OptionalAPI.getOptionalBlockPaintColor(tag, "Color", null);
        }
        storage.blockPaintColor = Optional.ofNullable(color);
        return color;
    }

    public static ArrayList<Component> getColorTooltips(IPaintColor color, boolean useDisplayColor) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        int rgb = color.getRGB();
        if (useDisplayColor) {
            rgb = ColorUtils.getDisplayRGB(color);
        }
        ISkinPaintType paintType = color.getPaintType();
        String hexColor = String.format("#%06x", rgb & 0xFFFFFF);
        MutableComponent paintName = TranslateUtils.Name.of(paintType);
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.colour", rgb & 0xFFFFFF));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.hex", hexColor));
        tooltips.add((Component)TranslateUtils.subtitle("item.armourers_workshop.rollover.paintType", paintName));
        return tooltips;
    }

    public static int mix(int a, int b, float q) {
        return (int)((float)a * (1.0f - q) + (float)b * q);
    }

    public static UIColor parseColor(String colorString) {
        try {
            long value = Long.decode(colorString);
            if ((value & 0xFFFFFFFFFF000000L) == 0L) {
                value |= 0xFFFFFFFFFF000000L;
            }
            return new UIColor((int)value, true);
        }
        catch (NumberFormatException e) {
            return UIColor.BLACK;
        }
    }

    public static int HSBtoRGB(float[] hsb) {
        return UIColor.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
    }

    public static float[] RGBtoHSB(IPaintColor paintColor) {
        int rgb = paintColor.getRGB();
        return UIColor.RGBtoHSB(ColorUtils.getRed(rgb), ColorUtils.getGreen(rgb), ColorUtils.getBlue(rgb), null);
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int getRGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    static {
        PALETTE_SHADES = new UIColor[32];
        ColorUtils.PALETTE_SHADES[0] = UIColor.WHITE;
        for (int i = 1; i < PALETTE_SHADES.length + 1; ++i) {
            ColorUtils.PALETTE_SHADES[i - 1] = new UIColor(8 * i - 1, 8 * i - 1, 8 * i - 1);
        }
    }
}

