/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.panels;

import com.apple.library.coregraphics.CGGradient;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIView;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.library.client.gui.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractLibraryPanel
extends UIView {
    public String baseKey;
    public final Predicate<GlobalSkinLibraryWindow.Page> predicate;
    protected GlobalSkinLibraryWindow.Router router;

    public AbstractLibraryPanel(String titleKey, Predicate<GlobalSkinLibraryWindow.Page> predicate) {
        super(new CGRect(0.0f, 0.0f, 320.0f, 240.0f));
        this.setContents(this.getDefaultColor());
        this.baseKey = titleKey;
        this.predicate = predicate;
    }

    public void tick() {
    }

    public void refresh() {
    }

    @Override
    public boolean pointInside(CGPoint point, UIEvent event) {
        if (super.pointInside(point, event)) {
            return true;
        }
        return this.subviews().stream().anyMatch(subview -> subview.pointInside(this.convertPointToView(point, (UIView)subview), event));
    }

    protected NSString getDisplayText(String key) {
        return new NSString((Component)TranslateUtils.title(this.baseKey + "." + key, new Object[0]));
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return new NSString((Component)TranslateUtils.title(this.baseKey + "." + key, objects));
    }

    protected NSString getCommonDisplayText(String key) {
        return new NSString((Component)TranslateUtils.title("inventory.armourers_workshop.common." + key, new Object[0]));
    }

    protected NSString getURLText(String url) {
        Style style = Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        return new NSString((Component)Component.m_237113_((String)url).m_130948_(style));
    }

    protected CGGradient getDefaultColor() {
        UIColor startColor = UIColor.rgba(-1072689136);
        UIColor endColor = UIColor.rgba(-804253680);
        return new CGGradient(startColor, CGPoint.ZERO, endColor, CGPoint.ZERO);
    }

    public GlobalSkinLibraryWindow.Router getRouter() {
        return this.router;
    }

    public void setRouter(GlobalSkinLibraryWindow.Router router) {
        this.router = router;
    }
}

