/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UILabelDelegate;
import com.apple.library.uikit.UIView;
import com.mojang.authlib.GameProfile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.client.gui.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.HeaderLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.HomeLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.InfoLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.JoinLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.ModerationLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.SearchBoxLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.SearchResultsLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.SkinDetailLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.SkinEditLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.UploadLibraryPanel;
import moe.plushie.armourers_workshop.library.client.gui.panels.UserSkinsLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.data.impl.SearchColumnType;
import moe.plushie.armourers_workshop.library.data.impl.SearchOrderType;
import moe.plushie.armourers_workshop.library.data.impl.ServerSkin;
import moe.plushie.armourers_workshop.library.data.impl.ServerUser;
import moe.plushie.armourers_workshop.library.menu.GlobalSkinLibraryMenu;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class GlobalSkinLibraryWindow
extends MenuWindow<GlobalSkinLibraryMenu> {
    private final Router router = new Router();
    private final ArrayList<AbstractLibraryPanel> panels = new ArrayList();
    private final HeaderLibraryPanel headerPanel = this.addPanel(HeaderLibraryPanel::new);
    private final SearchBoxLibraryPanel searchBoxPanel = this.addPanel(SearchBoxLibraryPanel::new);
    private final InfoLibraryPanel infoPanel = this.addPanel(InfoLibraryPanel::new);
    private final JoinLibraryPanel joinPanel = this.addPanel(JoinLibraryPanel::new);
    private final UploadLibraryPanel uploadPanel = this.addPanel(UploadLibraryPanel::new);
    private final ModerationLibraryPanel moderationPanel = this.addPanel(ModerationLibraryPanel::new);
    private final SearchResultsLibraryPanel searchResultsPanel = this.addPanel(SearchResultsLibraryPanel::new);
    private final UserSkinsLibraryPanel searchUserResultsPanel = this.addPanel(UserSkinsLibraryPanel::new);
    private final HomeLibraryPanel homePanel = this.addPanel(HomeLibraryPanel::new);
    private final SkinDetailLibraryPanel skinDetailPanel = this.addPanel(SkinDetailLibraryPanel::new);
    private final SkinEditLibraryPanel skinEditPanel = this.addPanel(SkinEditLibraryPanel::new);
    private Page page = Page.HOME;
    private boolean didInit = false;

    public GlobalSkinLibraryWindow(GlobalSkinLibraryMenu container, Inventory inventory, NSString title) {
        super(container, inventory, title);
        this.setFrame(new CGRect(0.0f, 0.0f, 640.0f, 480.0f));
        this.titleView.setTextColor(new UIColor(0xCCCCCC));
        this.inventoryView.setHidden(true);
    }

    private void setupLibrary() {
        Minecraft minecraft = Minecraft.m_91087_();
        GameProfile gameProfile = minecraft.m_91094_().m_92548_();
        GlobalSkinLibrary.getInstance().executor((Executor)minecraft);
        GlobalSkinLibrary.getInstance().connect(gameProfile, null);
    }

    private void setupUI() {
        float width = this.bounds().getWidth();
        float height = this.bounds().getHeight();
        this.headerPanel.setFrame(new CGRect(0.0f, 0.0f, width, 26.0f));
        this.searchBoxPanel.setFrame(new CGRect(0.0f, 27.0f, width, 23.0f));
        this.infoPanel.setFrame(new CGRect(0.0f, 27.0f, width, height - 27.0f));
        this.joinPanel.setFrame(new CGRect(0.0f, 27.0f, width, height - 27.0f));
        this.uploadPanel.setFrame(new CGRect(0.0f, 27.0f, width, height - 27.0f));
        this.moderationPanel.setFrame(new CGRect(0.0f, 27.0f, width, height - 27.0f));
        this.homePanel.setFrame(new CGRect(0.0f, 51.0f, width, height - 27.0f - 24.0f));
        this.searchResultsPanel.setFrame(new CGRect(0.0f, 51.0f, width, height - 27.0f - 24.0f));
        this.searchUserResultsPanel.setFrame(new CGRect(0.0f, 51.0f, width, height - 27.0f - 24.0f));
        this.skinDetailPanel.setFrame(new CGRect(0.0f, 51.0f, width, height - 27.0f - 24.0f));
        this.skinEditPanel.setFrame(new CGRect(0.0f, 51.0f, width, height - 27.0f - 24.0f));
        this.setVisible();
        if (this.didInit) {
            this.layoutIfNeeded();
            this.homePanel.reloadData();
        }
    }

    @Override
    public void init() {
        super.init();
        this.setupLibrary();
        this.setupUI();
        this.didInit = true;
    }

    @Override
    public void deinit() {
        super.deinit();
        this.panels.forEach(panel -> panel.setRouter(null));
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
        ((GlobalSkinLibraryMenu)this.menu).reload(0, 0, (int)size.width, (int)size.height);
        this.setupUI();
    }

    @Override
    public void screenWillTick() {
        super.screenWillTick();
        if (!this.didInit) {
            return;
        }
        GlobalSkinLibrary.getInstance().auth2();
        this.panels.forEach(AbstractLibraryPanel::tick);
    }

    private <T extends AbstractLibraryPanel> T addPanel(Supplier<T> provider) {
        AbstractLibraryPanel value = (AbstractLibraryPanel)provider.get();
        value.setRouter(this.router);
        this.panels.add(value);
        return (T)value;
    }

    private void setVisible() {
        this.panels.forEach(p -> {
            if (p.predicate.test(this.page)) {
                if (p.superview() != this) {
                    this.insertViewAtIndex((UIView)p, 0);
                    p.refresh();
                }
            } else {
                p.removeFromSuperview();
            }
        });
    }

    private void setPage(Page page) {
        this.page = page;
        this.setVisible();
    }

    public class Router
    implements ISkinListListener,
    UILabelDelegate {
        public void showPage(Page page) {
            GlobalSkinLibraryWindow.this.setPage(page);
        }

        public void showNewHome() {
            GlobalSkinLibraryWindow.this.homePanel.reloadData();
            GlobalSkinLibraryWindow.this.setPage(Page.HOME);
        }

        public void showSkinList(String keyword, ISkinType skinType, SearchColumnType columnType, SearchOrderType orderType) {
            ModLog.debug("select * from global_library where keyword = '{}' and skinType = {} order by {} {}", new Object[]{keyword, skinType, columnType, orderType});
            GlobalSkinLibraryWindow.this.searchBoxPanel.reloadData(keyword, skinType, columnType, orderType);
            GlobalSkinLibraryWindow.this.searchResultsPanel.reloadData(keyword, skinType, columnType, orderType);
            GlobalSkinLibraryWindow.this.setPage(Page.LIST_SEARCH);
        }

        public void showSkinList(ServerUser user) {
            if (user == null || !user.isMember()) {
                return;
            }
            GlobalSkinLibraryWindow.this.searchBoxPanel.reloadData("", SkinTypes.UNKNOWN, SearchColumnType.DATE_CREATED, SearchOrderType.DESC);
            GlobalSkinLibraryWindow.this.searchUserResultsPanel.reloadData(user);
            GlobalSkinLibraryWindow.this.setPage(Page.LIST_USER_SKINS);
        }

        public void showSkinDetail(ServerSkin entry, Page returnPage) {
            GlobalSkinLibraryWindow.this.skinDetailPanel.reloadData(entry, returnPage);
            GlobalSkinLibraryWindow.this.setPage(Page.SKIN_DETAIL);
        }

        public void showSkinEdit(ServerSkin entry, Page returnPage) {
            GlobalSkinLibraryWindow.this.skinEditPanel.reloadData(entry, returnPage);
            GlobalSkinLibraryWindow.this.setPage(Page.SKIN_EDIT);
        }

        @Override
        public void labelWillClickAttributes(UILabel label, Map<String, ?> attributes) {
            ClickEvent clickEvent = ObjectUtils.safeCast(attributes.get("ClickEvent"), ClickEvent.class);
            if (clickEvent == null || clickEvent.m_130622_() != ClickEvent.Action.OPEN_URL) {
                return;
            }
            String value = clickEvent.m_130623_();
            try {
                URI uri = new URI(value);
                String s = uri.getScheme();
                if (s == null) {
                    throw new URISyntaxException(value, "Missing protocol");
                }
                Util.m_137581_().m_137648_(uri);
            }
            catch (URISyntaxException urisyntaxexception) {
                ModLog.error("Can't open url for {}", value, urisyntaxexception);
            }
        }

        public GlobalSkinLibraryMenu menu() {
            return (GlobalSkinLibraryMenu)GlobalSkinLibraryWindow.this.menu;
        }

        @Override
        public void skinDidChange(String skinId, @Nullable ServerSkin newValue) {
            for (AbstractLibraryPanel panel : GlobalSkinLibraryWindow.this.panels) {
                if (!(panel instanceof ISkinListListener)) continue;
                ((ISkinListListener)((Object)panel)).skinDidChange(skinId, newValue);
            }
        }
    }

    public static enum Page {
        HOME(true),
        LIBRARY_INFO(false),
        LIBRARY_JOIN(false),
        LIBRARY_MODERATION(false),
        SKIN_UPLOAD(false),
        SKIN_EDIT(true),
        SKIN_DETAIL(true),
        LIST_SEARCH(true),
        LIST_USER_SKINS(true);

        final boolean hasSearch;

        private Page(boolean hasSearch) {
            this.hasSearch = hasSearch;
        }

        public boolean hasSearch() {
            return this.hasSearch;
        }
    }

    public static interface ISkinListListener {
        public void skinDidChange(String var1, @Nullable ServerSkin var2);
    }
}

