/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootConditionalFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import moe.plushie.armourers_workshop.api.data.IDataPackObject;
import moe.plushie.armourers_workshop.api.registry.ILootFunctionBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.core.Registry.LootFunction;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootFunctionBuilderImpl<T extends ILootFunction>
implements ILootFunctionBuilder<T> {
    private final Supplier<ILootFunction.Serializer<T>> serializer;

    public LootFunctionBuilderImpl(Supplier<ILootFunction.Serializer<T>> serializer) {
        this.serializer = serializer;
    }

    @Override
    public IRegistryKey<ILootFunctionType<T>> build(String name) {
        LootItemFunctionType[] type = new LootItemFunctionType[]{null};
        ResourceLocation registryName = ModConstants.key(name);
        type[0] = this.createType(() -> type[0], this.serializer.get());
        Proxy proxy = new Proxy(type[0]);
        LootFunction.registerItemLootFunctionFO(Registry.class, name, () -> type[0]);
        return new AbstractForgeRegistryEntry<ILootFunctionType<T>>(registryName, () -> proxy);
    }

    public LootItemFunctionType createType(Supplier<LootItemFunctionType> type, ILootFunction.Serializer<T> serializer) {
        if (serializer instanceof ILootConditionalFunction.Serializer) {
            ILootConditionalFunction.Serializer serializer2 = (ILootConditionalFunction.Serializer)ObjectUtils.unsafeCast(serializer);
            return new LootItemFunctionType(new ConditionalFunction.Factory(type, serializer2));
        }
        return new LootItemFunctionType(new NormalFunction.Factory<T>(type, serializer));
    }

    public static class Proxy<T extends ILootFunction>
    implements ILootFunctionType<T> {
        private final LootItemFunctionType type;

        public Proxy(LootItemFunctionType type) {
            this.type = type;
        }
    }

    public static class ConditionalFunction<T extends ILootConditionalFunction>
    extends LootItemConditionalFunction {
        private final T value;
        private final Supplier<LootItemFunctionType> type;

        protected ConditionalFunction(T value, LootItemCondition[] args, Supplier<LootItemFunctionType> type) {
            super(args);
            this.type = type;
            this.value = value;
        }

        protected ItemStack m_7372_(ItemStack arg, LootContext arg2) {
            return this.value.apply(arg, arg2);
        }

        public void m_6169_(ValidationContext arg) {
            this.value.m_6169_(arg);
        }

        public Set<LootContextParam<?>> m_6231_() {
            return this.value.m_6231_();
        }

        public LootItemFunctionType m_7162_() {
            return this.type.get();
        }

        public static class Factory<T extends ILootConditionalFunction>
        extends LootItemConditionalFunction.Serializer<ConditionalFunction<T>> {
            private final Supplier<LootItemFunctionType> type;
            private final ILootConditionalFunction.Serializer<T> serializer;

            public Factory(Supplier<LootItemFunctionType> type, ILootConditionalFunction.Serializer<T> serializer) {
                this.type = type;
                this.serializer = serializer;
            }

            public void serialize(JsonObject object, ConditionalFunction<T> arg, JsonSerializationContext context) {
                super.m_6170_(object, arg, context);
                this.serializer.serialize(IDataPackObject.of((JsonElement)object), arg.value);
            }

            public ConditionalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] args) {
                ILootConditionalFunction value = (ILootConditionalFunction)this.serializer.deserialize(IDataPackObject.of((JsonElement)object));
                return new ConditionalFunction<ILootConditionalFunction>(value, args, this.type);
            }
        }
    }

    public static class NormalFunction<T extends ILootFunction>
    implements LootItemFunction {
        private final T value;
        private final Supplier<LootItemFunctionType> type;

        public NormalFunction(T value, Supplier<LootItemFunctionType> type) {
            this.type = type;
            this.value = value;
        }

        public LootItemFunctionType m_7162_() {
            return this.type.get();
        }

        public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
            return this.value.apply(itemStack, lootContext);
        }

        public void m_6169_(ValidationContext arg) {
            this.value.m_6169_(arg);
        }

        public Set<LootContextParam<?>> m_6231_() {
            return this.value.m_6231_();
        }

        public static class Factory<T extends ILootFunction>
        implements Serializer<NormalFunction<T>> {
            private final Supplier<LootItemFunctionType> type;
            private final ILootFunction.Serializer<T> serializer;

            public Factory(Supplier<LootItemFunctionType> type, ILootFunction.Serializer<T> serializer) {
                this.type = type;
                this.serializer = serializer;
            }

            public void serialize(JsonObject object, NormalFunction<T> arg, JsonSerializationContext context) {
                this.serializer.serialize(IDataPackObject.of((JsonElement)object), arg.value);
            }

            public NormalFunction<T> deserialize(JsonObject object, JsonDeserializationContext context) {
                T value = this.serializer.deserialize(IDataPackObject.of((JsonElement)object));
                return new NormalFunction<T>(value, this.type);
            }
        }
    }
}

