/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.LinkedList;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.registry.IBlockEntityTypeBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryBinder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBlockEntityRendererProvider;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeBlockEntity;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistryEntry;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.client.renderer.GameRenderer.ForgeRegistry;
import moe.plushie.armourers_workshop.compatibility.forge.extensions.net.minecraft.core.Registry.ForgeProvider;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityTypeBuilderImpl<T extends BlockEntity>
implements IBlockEntityTypeBuilder<T> {
    private IRegistryBinder<BlockEntityType<T>> binder;
    private final LinkedList<Supplier<Block>> blocks = new LinkedList();
    private final IBlockEntityType.Serializer<T> supplier;

    public BlockEntityTypeBuilderImpl(IBlockEntityType.Serializer<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public IBlockEntityTypeBuilder<T> of(Supplier<Block> block) {
        this.blocks.add(block);
        return this;
    }

    @Override
    public IBlockEntityTypeBuilder<T> bind(Supplier<AbstractBlockEntityRendererProvider<T>> provider) {
        this.binder = () -> arg_0 -> BlockEntityTypeBuilderImpl.lambda$bind$0((Supplier)provider, arg_0);
        return this;
    }

    @Override
    public IRegistryKey<IBlockEntityType<T>> build(String name) {
        IRegistryKey object = ForgeProvider.registerBlockEntityTypeFO(Registry.class, name, () -> {
            Block[] blocks1 = (Block[])this.blocks.stream().map(Supplier::get).toArray(Block[]::new);
            return AbstractForgeBlockEntity.createType(this.supplier, blocks1);
        });
        Proxy proxy = new Proxy(object);
        EnvironmentExecutor.willInit(EnvironmentType.CLIENT, IRegistryBinder.perform(this.binder, object));
        return AbstractForgeRegistryEntry.of(object.getRegistryName(), () -> proxy);
    }

    private static /* synthetic */ void lambda$bind$0(Supplier provider, IRegistryKey blockEntityType) {
        ForgeRegistry.registerBlockEntityRendererFO(GameRenderer.class, blockEntityType, (AbstractBlockEntityRendererProvider)provider.get());
    }

    public static class Proxy<T extends BlockEntity>
    implements IBlockEntityType<T> {
        private final IRegistryKey<BlockEntityType<T>> object;

        public Proxy(IRegistryKey<BlockEntityType<T>> object) {
            this.object = object;
        }

        @Override
        public T create(BlockGetter level, BlockPos blockPos, BlockState blockState) {
            return AbstractForgeBlockEntity.create((BlockEntityType)this.object.get(), level, blockPos, blockState);
        }

        @Override
        public BlockEntityType<T> get() {
            return (BlockEntityType)this.object.get();
        }
    }
}

