/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.platform.ReplayManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ServerReplayPacket
extends CustomPacket {
    private final Event event;
    private final FriendlyByteBuf parameters;

    public ServerReplayPacket(Event event, Consumer<FriendlyByteBuf> consumer) {
        this.event = event;
        if (consumer != null) {
            this.parameters = new FriendlyByteBuf(Unpooled.buffer());
            consumer.accept(this.parameters);
        } else {
            this.parameters = null;
        }
    }

    public ServerReplayPacket(FriendlyByteBuf buffer) {
        this.event = (Event)buffer.m_130066_(Event.class);
        int size = buffer.readInt();
        this.parameters = size != 0 ? new FriendlyByteBuf(buffer.readBytes(size)) : null;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.event);
        if (this.parameters != null) {
            buffer.writeInt(this.parameters.readableBytes());
            buffer.writeBytes((ByteBuf)this.parameters);
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        ReplayManager.accept(this);
    }

    public Event getEvent() {
        return this.event;
    }

    public FriendlyByteBuf getParameters() {
        return this.parameters;
    }

    public static enum Event {
        START_RECORDING,
        STOP_RECORDING;

    }
}

