/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.model.BakedModelStorage;
import moe.plushie.armourers_workshop.core.client.model.FirstPersonPlayerModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.platform.TransformationProvider;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
public class ClientWardrobeHandler {
    public static ItemStack RENDERING_GUI_ITEM = null;
    public static final float SCALE = 0.0625f;

    public static void init() {
    }

    public static void startRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = itemStack;
    }

    public static void endRenderGuiItem(ItemStack itemStack) {
        RENDERING_GUI_ITEM = null;
    }

    public static void onRenderTrident(ThrownTrident entity, Model model, float partialTicks, int packedLight, PoseStack poseStack, MultiBufferSource buffers, CallbackInfo callback) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        poseStack.m_85836_();
        float xRot = entity.m_146909_();
        float yRot = entity.m_146908_();
        float xRotO = entity.f_19860_;
        float yRotO = entity.f_19859_;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(MathUtils.lerp(partialTicks, yRotO, yRot) - 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(MathUtils.lerp(partialTicks, xRotO, xRot) + 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(180.0f));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-90.0f));
        poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
        poseStack.m_85837_(0.0, 11.0, 0.0);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, model, context, renderData::getItemSkins);
        if (count != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
        context.release();
        poseStack.m_85849_();
    }

    public static void onRenderArrow(AbstractArrow entity, Model model, float partialTicks, int packedLight, PoseStack poseStack, MultiBufferSource buffers, CallbackInfo callback) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        SkinRenderData.Entry entry = ClientWardrobeHandler.getEntry(renderData.getItemSkins(), part -> part.getType() == SkinPartTypes.ITEM_ARROW);
        if (entry == null) {
            return;
        }
        poseStack.m_85836_();
        float xRot = entity.m_146909_();
        float yRot = entity.m_146908_();
        float xRotO = entity.f_19860_;
        float yRotO = entity.f_19859_;
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(MathUtils.lerp(partialTicks, yRotO, yRot) - 90.0f));
        ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(MathUtils.lerp(partialTicks, xRotO, xRot)));
        float f9 = (float)entity.f_36706_ - partialTicks;
        if (f9 > 0.0f) {
            float f10 = -MathUtils.sin(f9 * 3.0f) * f9;
            ABI.mulPose(poseStack, Vector3f.ZP.rotationDegrees(f10));
        }
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-90.0f));
        poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
        poseStack.m_85837_(0.0, 0.0, -1.0);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, model, context, () -> Collections.singletonList(entry));
        if (count != 0 && !ModDebugger.itemOverride) {
            callback.cancel();
        }
        context.release();
        poseStack.m_85849_();
    }

    public static void onRenderSpecificHand(LivingEntity entity, float partialTicks, int packedLight, AbstractItemTransformType transformType, PoseStack poseStack, MultiBufferSource buffers, Runnable cancelHandler) {
        FirstPersonPlayerModel<?> model = FirstPersonPlayerModel.getInstance();
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
        SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), transformType, poseStack, buffers);
        int count = ClientWardrobeHandler.render((Entity)entity, model, context, renderData::getArmorSkins);
        if (count != 0 && !ModDebugger.handOverride) {
            cancelHandler.run();
        }
        context.release();
        poseStack.m_85849_();
    }

    public static void onRenderLivingPre(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStack, MultiBufferSource buffers, LivingEntityRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().willRender(entity, (Model)entityRenderer.m_7200_(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    public static void onRenderLiving(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStack, MultiBufferSource buffers, LivingEntityRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().willRenderModel(entity, (Model)entityRenderer.m_7200_(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    public static void onRenderLivingPost(LivingEntity entity, float partialTicks, int packedLight, PoseStack poseStack, MultiBufferSource buffers, LivingEntityRenderer<?, ?> entityRenderer) {
        SkinRenderData renderData = SkinRenderData.of((Entity)entity);
        if (renderData != null) {
            SkinRendererManager.getInstance().didRender(entity, (Model)entityRenderer.m_7200_(), (EntityRenderer<?>)entityRenderer, renderData, () -> SkinRenderContext.alloc(renderData, packedLight, partialTicks, poseStack, buffers));
        }
    }

    @Nullable
    public static EmbeddedSkinStack getEmbeddedSkinStack(@Nullable LivingEntity entity, @Nullable Level level, ItemStack itemStack, AbstractItemTransformType transformType) {
        Iterator<SkinRenderData.Entry> iterator;
        SkinRenderData renderData;
        if (RENDERING_GUI_ITEM != itemStack && (renderData = SkinRenderData.of((Entity)entity)) != null && (iterator = renderData.getItemSkins(itemStack, entity instanceof MannequinEntity).iterator()).hasNext()) {
            SkinRenderData.Entry entry = iterator.next();
            return new EmbeddedSkinStack(entry);
        }
        if (itemStack.m_150930_((Item)ModItems.SKIN.get())) {
            return null;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.isEmpty()) {
            return null;
        }
        if (descriptor.getOptions().getEmbeddedItemRenderer() != 0) {
            if (descriptor.getOptions().getEmbeddedItemRenderer() == 2) {
                return new EmbeddedSkinStack(descriptor, itemStack);
            }
            return null;
        }
        if (ModConfig.enableEmbeddedSkinRenderer() || descriptor.getType() == SkinTypes.ITEM) {
            return new EmbeddedSkinStack(descriptor, itemStack);
        }
        return null;
    }

    public static void renderEmbeddedSkin(@Nullable LivingEntity entity, @Nullable Level level, ItemStack itemStack, EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStack, MultiBufferSource buffers, BakedModel bakedModel, int packedLight, int overlay, CallbackInfo callback) {
        int counter = 0;
        switch (transformType) {
            case GUI: 
            case GROUND: 
            case FIXED: {
                ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                callback.cancel();
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                if (embeddedStack.getEntry() == null) {
                    if (ClientWardrobeHandler.shouldRenderInBox(embeddedStack)) {
                        ClientWardrobeHandler._renderEmbeddedSkinInBox(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                    } else {
                        ClientWardrobeHandler._renderEmbeddedSkin(embeddedStack, transformType, leftHandHackery, poseStack, buffers, packedLight, overlay);
                    }
                    callback.cancel();
                    return;
                }
                SkinRenderData renderData = SkinRenderData.of((Entity)entity);
                if (renderData == null) break;
                poseStack.m_85836_();
                poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
                SkinRenderContext context = SkinRenderContext.alloc(renderData, packedLight, TickUtils.ticks(), transformType, poseStack, buffers);
                context.setReference(800.0f, itemStack);
                counter = ClientWardrobeHandler.render((Entity)entity, null, context, () -> Collections.singleton(embeddedStack.getEntry()));
                if (counter != 0 && !ModDebugger.itemOverride) {
                    callback.cancel();
                }
                context.release();
                poseStack.m_85849_();
                break;
            }
        }
    }

    public static void _renderEmbeddedSkinInBox(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int overlay) {
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        poseStack.m_85836_();
        TransformationProvider.handleTransforms(poseStack, BakedModelStorage.getSkinBakedModel(), transformType, leftHandHackery);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        SkinItemRenderer.getInstance().renderByItem(descriptor.sharedItemStack(), transformType, poseStack, buffers, packedLight, overlay);
        poseStack.m_85849_();
    }

    public static int _renderEmbeddedSkin(EmbeddedSkinStack embeddedStack, AbstractItemTransformType transformType, boolean leftHandHackery, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int overlay) {
        int counter = 0;
        SkinDescriptor descriptor = embeddedStack.getDescriptor();
        SkinRenderTesselator context = SkinRenderTesselator.create(descriptor, Tickets.INVENTORY);
        if (context == null) {
            return counter;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(-0.0625f, -0.0625f, 0.0625f);
        context.setRenderData(SkinRenderData.of((Entity)context.getMannequin()));
        context.setLightmap(packedLight);
        context.setPartialTicks(0.0f);
        context.setReference(embeddedStack.getItemStack(), 800.0f, null);
        context.setColorScheme(descriptor.getColorScheme());
        counter = context.draw(poseStack, buffers);
        poseStack.m_85849_();
        return counter;
    }

    public static void onRenderEntityInInventoryPre(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY) {
        int top;
        int left;
        int height;
        int width;
        if (!ModConfig.Client.enableEntityInInventoryClip) {
            return;
        }
        switch (scale) {
            case 20: {
                width = 32;
                height = 43;
                left = x - width / 2 + 1;
                top = y - height + 4;
                break;
            }
            case 30: {
                width = 49;
                height = 70;
                left = x - width / 2 - 1;
                top = y - height + 3;
                break;
            }
            default: {
                return;
            }
        }
        RenderSystem.addClipRect(left, top, width, height);
    }

    public static void onRenderEntityInInventoryPost(LivingEntity entity) {
        if (!ModConfig.Client.enableEntityInInventoryClip) {
            return;
        }
        RenderSystem.removeClipRect();
    }

    private static int render(Entity entity, Model model, SkinRenderContext context, Supplier<Iterable<SkinRenderData.Entry>> provider) {
        int r = 0;
        SkinRenderer<Entity, IModel> renderer = SkinRendererManager.getInstance().getRenderer(entity, model, null);
        if (renderer == null) {
            return 0;
        }
        Object modelHolder = ModelHolder.ofNullable(model);
        for (SkinRenderData.Entry entry : provider.get()) {
            ItemStack itemStack = context.getReference();
            if (itemStack.m_41619_()) {
                itemStack = entry.getItemStack();
            }
            context.setReference(entry.getRenderPriority(), itemStack);
            context.setTransforms(entity, renderer.getOverrideModel((IModel)modelHolder));
            r += renderer.render(entity, (IModel)modelHolder, entry.getBakedSkin(), entry.getBakedScheme(), context);
        }
        return r;
    }

    private static boolean shouldRenderInBox(EmbeddedSkinStack embeddedStack) {
        ISkinType skinType = embeddedStack.getDescriptor().getType();
        if (skinType instanceof ISkinToolType) {
            return false;
        }
        return skinType != SkinTypes.ITEM;
    }

    private static SkinRenderData.Entry getEntry(Iterable<SkinRenderData.Entry> entries, Predicate<BakedSkinPart> predicate) {
        for (SkinRenderData.Entry entry1 : entries) {
            for (BakedSkinPart part : entry1.getBakedSkin().getSkinParts()) {
                if (!predicate.test(part)) continue;
                return entry1;
            }
        }
        return null;
    }
}

