/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.data.serialize.v20.chunk;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public class ChunkContext {
    private byte[] securityKey = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    public InputStream createInputStream(ByteBuf buf, int flags) throws IOException {
        Object inputStream = new ByteBufInputStream(buf);
        if ((flags & 1) != 0) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(2, key);
                inputStream = new CipherInputStream((InputStream)inputStream, aes);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if ((flags & 2) != 0) {
            inputStream = new GZIPInputStream((InputStream)inputStream);
        }
        return inputStream;
    }

    public OutputStream createOutputStream(ByteBuf buf, int flags) throws IOException {
        Object outputStream = new ByteBufOutputStream(buf);
        if ((flags & 1) != 0) {
            if (this.securityKey == null || this.securityKey.length == 0) {
                throw new IOException("missing security key!!");
            }
            try {
                SecretKeySpec key = new SecretKeySpec(this.securityKey, "AES");
                Cipher aes = Cipher.getInstance("AES/ECB/PKCS5Padding");
                aes.init(1, key);
                outputStream = new CipherOutputStream((OutputStream)outputStream, aes);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        if ((flags & 2) != 0) {
            outputStream = new GZIPOutputStream((OutputStream)outputStream);
        }
        return outputStream;
    }
}

