/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.network.ResponseSkinPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class RequestSkinPacket
extends CustomPacket {
    private final String identifier;

    public RequestSkinPacket(String identifier) {
        this.identifier = identifier;
    }

    public RequestSkinPacket(FriendlyByteBuf buffer) {
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.identifier);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ModLog.debug("'{}' => accept skin request", this.identifier);
        SkinLoader.getInstance().loadSkin(this.identifier, (skin, exception) -> {
            ModLog.debug("'{}' => response skin data, exception: {}", this.identifier, exception);
            ResponseSkinPacket packet = new ResponseSkinPacket(this.identifier, (Skin)skin, exception);
            NetworkManager.sendTo(packet, player);
        });
    }
}

