/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockContainerMenu;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.util.Strings;

public class SkinnableMenu
extends AbstractBlockContainerMenu {
    private final String title;
    private int row;
    private int column;
    private Container inventory;

    public SkinnableMenu(MenuType<?> menuType, Block block, int containerId, Inventory playerInventory, IContainerLevelAccess worldPos) {
        super(menuType, block, containerId, worldPos);
        SkinnableBlockEntity blockEntity = (SkinnableBlockEntity)this.getBlockEntity();
        this.title = blockEntity.getInventoryName();
        this.row = 3;
        this.column = 9;
        this.inventory = playerInventory.f_35978_.m_36327_();
        if (!blockEntity.isEnderInventory()) {
            this.row = blockEntity.getInventoryHeight();
            this.column = blockEntity.getInventoryWidth();
            this.inventory = blockEntity.getInventory();
        }
        int guiTop = 20;
        int guiMiddle = 6;
        int guiWidth = 176;
        this.addPlayerSlots((Container)playerInventory, 8, guiTop + this.row * 18 + guiMiddle + 16);
        this.addCustomSlots(this.inventory, (guiWidth - this.column * 18) / 2, guiTop);
        if (this.inventory != null) {
            this.inventory.m_5856_(playerInventory.f_35978_);
        }
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        return this.quickMoveStack(player, index, this.f_38839_.size());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.inventory != null) {
            this.inventory.m_5785_(player);
        }
    }

    protected void addCustomSlots(Container inventory, int x, int y) {
        if (inventory == null) {
            return;
        }
        for (int j = 0; j < this.row; ++j) {
            for (int i = 0; i < this.column; ++i) {
                this.m_38897_(new Slot(inventory, i + j * this.column, x + 18 * i + 1, y + j * 18 + 1));
            }
        }
    }

    public Component getInventoryName() {
        if (Strings.isNotBlank((String)this.title)) {
            return TranslateUtils.formatted(this.title);
        }
        return Component.m_237115_((String)"inventory.armourers_workshop.skinnable");
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }
}

