/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import java.util.Calendar;
import java.util.HashSet;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class HolidayTracker
extends AbstractSavedData {
    private final Calendar calendar = Calendar.getInstance();
    private final HashSet<String> logs = new HashSet();

    public static HolidayTracker of(MinecraftServer server) {
        return DataProvider.computeIfAbsent(server.m_129783_().m_8895_(), HolidayTracker::new, 0, "HolidayTracker");
    }

    public void add(Player player, Holiday holiday) {
        ModLog.info("give a {} gift sack for the {}", holiday.getName(), player.m_6302_());
        this.logs.add(this.getKey(player, holiday));
        this.m_77762_();
    }

    public void remove(Player player, Holiday holiday) {
        ModLog.info("take a {} gift sack for the {}", holiday.getName(), player.m_6302_());
        this.logs.remove(this.getKey(player, holiday));
        this.m_77762_();
    }

    public boolean has(Player player, Holiday holiday) {
        return this.logs.contains(this.getKey(player, holiday));
    }

    @Override
    public void load(CompoundTag tag) {
        this.logs.clear();
        String prefix = this.calendar.get(1) + ":";
        ListTag listNBT = tag.m_128437_("Logs", 8);
        int size = listNBT.size();
        for (int i = 0; i < size; ++i) {
            String log = listNBT.m_128778_(i);
            if (!log.startsWith(prefix)) continue;
            this.logs.add(log);
        }
    }

    @Override
    public CompoundTag m_7176_(CompoundTag nbt) {
        String prefix = this.calendar.get(1) + ":";
        ListTag listNBT = new ListTag();
        for (String log : this.logs) {
            if (!log.startsWith(prefix)) continue;
            listNBT.add((Object)StringTag.m_129297_((String)log));
        }
        nbt.m_128365_("Logs", (Tag)listNBT);
        return nbt;
    }

    private String getKey(Player player, Holiday holiday) {
        return this.calendar.get(1) + ":" + holiday.getName() + ":" + player.m_20149_();
    }
}

