/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.api.common.IEntityType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractItemStackRenderer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.block.model.ItemTransforms.TypeConverter;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.render.ExtendedItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModEntityTypes;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinItemRenderer
extends AbstractItemStackRenderer {
    private static SkinItemRenderer INSTANCE;
    private ItemStack playerMannequinItem;
    private MannequinEntity entity;
    private MannequinModel<MannequinEntity> model;

    public static SkinItemRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SkinItemRenderer();
        }
        return INSTANCE;
    }

    @Override
    public void renderByItem(ItemStack itemStack, AbstractItemTransformType transformType, PoseStack poseStack, MultiBufferSource renderTypeBuffer, int light, int overlay) {
        if (itemStack.m_41619_()) {
            return;
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, Tickets.INVENTORY);
        if (bakedSkin == null) {
            return;
        }
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109406_(itemStack);
        ItemTransform transform = bakedModel.m_7442_().m_111808_(TypeConverter.ofType(ItemTransforms.class, transformType));
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Vector3f rotation = new Vector3f(-transform.f_111755_.m_122239_(), -transform.f_111755_.m_122260_(), transform.f_111755_.m_122269_());
        Vector3f scale = Vector3f.ONE;
        ColorScheme scheme = descriptor.getColorScheme();
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, rotation, scale, 1.0f, 1.0f, 1.0f, 0.0f, light, poseStack, renderTypeBuffer);
        poseStack.m_85849_();
    }

    public MannequinEntity getMannequinEntity() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (this.entity == null) {
            this.entity = new MannequinEntity((EntityType<? extends MannequinEntity>)((EntityType)((IEntityType)ModEntityTypes.MANNEQUIN.get()).get()), (Level)level);
            this.entity.m_20234_(-1);
            this.entity.setExtraRenderer(false);
        }
        if (this.entity.m_9236_() != level) {
            this.entity.changeLevel((Level)level);
        }
        return this.entity;
    }

    public MannequinModel<?> getMannequinModel() {
        MannequinEntity entity = this.getMannequinEntity();
        if (this.model == null && entity != null) {
            this.model = new MannequinModel();
            this.model.f_102610_ = false;
            this.model.f_102817_ = false;
            this.model.f_102609_ = false;
            this.model.m_6839_((LivingEntity)entity, 0.0f, 0.0f, 0.0f);
            this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        return this.model;
    }

    public ItemStack getPlayerMannequinItem() {
        if (this.playerMannequinItem == null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return ItemStack.f_41583_;
            }
            this.playerMannequinItem = MannequinItem.of((Player)player, 1.0f);
        }
        return this.playerMannequinItem;
    }
}

