/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractLivingEntityRenderer;
import moe.plushie.armourers_workshop.core.client.model.MannequinArmorModel;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinEntityRenderer<T extends MannequinEntity>
extends AbstractLivingEntityRenderer<T, MannequinModel<T>> {
    public static boolean enableLimitScale = false;
    public static boolean enableLimitYRot = false;
    private final AbstractEntityRendererProviderImpl.Context context;
    private final MannequinModel<T> normalModel;
    private final MannequinModel<T> slimModel;
    private MannequinEntityRenderer<T> mannequinRenderer;
    private ResourceLocation texture;
    private BakedEntityTexture bakedTexture;
    private boolean enableChildRenderer = false;

    public MannequinEntityRenderer(AbstractEntityRendererProviderImpl.Context context) {
        super(context, new MannequinModel(context, 0.0f, false), 0.0f);
        this.m_115326_(this.getLayerProvider().createHumanoidArmorLayer(context, MannequinArmorModel.innerModel(context), MannequinArmorModel.outerModel(context)));
        this.m_115326_(this.getLayerProvider().createItemInHandLayer(context));
        this.m_115326_(this.getLayerProvider().createElytraLayer(context));
        this.m_115326_(this.getLayerProvider().createCustomHeadLayer(context));
        this.normalModel = (MannequinModel)super.m_7200_();
        this.slimModel = new MannequinModel(context, 0.0f, true);
        this.context = context;
    }

    public boolean shouldShowName(T entity) {
        return entity.m_8077_();
    }

    public void render(T entity, float f, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLightIn) {
        if (this.enableChildRenderer) {
            this.getChildRenderer().render(entity, f, partialTicks, poseStack, buffers, packedLightIn);
            return;
        }
        PlayerTextureLoader textureLoader = PlayerTextureLoader.getInstance();
        this.texture = textureLoader.getTextureLocation((Entity)entity);
        this.bakedTexture = textureLoader.getTextureModel(this.texture);
        this.setModel(this.getModel());
        ((MannequinModel)super.m_7200_()).m_8009_(((MannequinEntity)entity).isModelVisible());
        this.enableChildRenderer = true;
        super.m_7392_(entity, f, partialTicks, poseStack, buffers, packedLightIn);
        this.enableChildRenderer = false;
        if (ModDebugger.mannequinCulling) {
            poseStack.m_85836_();
            AABB box = ((MannequinEntity)entity).m_6921_();
            double tx = -box.f_82288_ - (box.f_82291_ - box.f_82288_) / 2.0;
            double ty = -box.f_82289_;
            double tz = -box.f_82290_ - (box.f_82293_ - box.f_82290_) / 2.0;
            poseStack.m_85837_((double)((float)tx), (double)((float)ty), (double)((float)tz));
            ShapeTesselator.stroke(box, UIColor.YELLOW, poseStack, buffers);
            poseStack.m_85849_();
        }
    }

    public void scale(T entity, PoseStack poseStack, float p_225620_3_) {
        float f = 0.9375f;
        if (!enableLimitScale) {
            f *= ((MannequinEntity)entity).m_6134_();
        }
        poseStack.m_85841_(f, f, f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }

    public MannequinModel<T> getModel() {
        if (this.bakedTexture != null && this.bakedTexture.isSlimModel()) {
            return this.slimModel;
        }
        return this.normalModel;
    }

    public MannequinEntityRenderer<T> getChildRenderer() {
        if (this.mannequinRenderer == null) {
            this.mannequinRenderer = new MannequinEntityRenderer<T>(this.context);
        }
        return this.mannequinRenderer;
    }
}

