/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighlightPlacementRenderer {
    public static void renderBlock(ItemStack itemStack, Player player, BlockHitResult traceResult, Camera renderInfo, PoseStack poseStack, MultiBufferSource buffers) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return;
        }
        poseStack.m_85836_();
        float f = 0.0625f;
        Vector3f origin = new Vector3f((Position)renderInfo.m_90583_());
        SkinBlockPlaceContext context = new SkinBlockPlaceContext(player, InteractionHand.MAIN_HAND, itemStack, traceResult);
        BlockPos location = context.m_8083_();
        poseStack.m_85837_((double)((float)location.m_123341_() - origin.getX()), (double)((float)location.m_123342_() - origin.getY()), (double)((float)location.m_123343_() - origin.getZ()));
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(f, f, f);
        for (SkinBlockPlaceContext.Part part : context.getParts()) {
            BlockPos pos = part.getOffset();
            UIColor color = UIColor.RED;
            if (context.canPlace(part)) {
                color = UIColor.WHITE;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)pos.m_123341_() * 16.0f), (double)((float)pos.m_123342_() * 16.0f), (double)((float)pos.m_123343_() * 16.0f));
            ShapeTesselator.stroke(part.getShape(), color, poseStack, buffers);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public static void renderEntity(Player player, BlockHitResult traceResult, Camera renderInfo, PoseStack poseStack, MultiBufferSource buffers) {
        Vector3f origin = new Vector3f((Position)renderInfo.m_90583_());
        MannequinHitResult target = MannequinHitResult.test(player, origin, traceResult.m_82450_(), traceResult.m_82425_());
        poseStack.m_85836_();
        Vector3f location = new Vector3f((Position)target.m_82450_());
        poseStack.m_85837_((double)(location.getX() - origin.getX()), (double)(location.getY() - origin.getY()), (double)(location.getZ() - origin.getZ()));
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(-target.getRotation()));
        MannequinModel<?> model = SkinItemRenderer.getInstance().getMannequinModel();
        if (model != null) {
            float f = target.getScale() * 0.9375f;
            VertexConsumer builder = buffers.m_6299_(SkinRenderType.HIGHLIGHTED_ENTITY_LINES);
            poseStack.m_85836_();
            poseStack.m_85841_(f, f, f);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_85837_(0.0, (double)-1.501f, 0.0);
            model.m_7695_(poseStack, builder, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

