/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.PoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.vertex.PoseStack.ABI;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderTesselator;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class ExtendedItemRenderer {
    public static void renderSkinInBox(BakedSkin bakedSkin, float x, float y, float z, float width, float height, float rx, float ry, float rz, PoseStack poseStack, MultiBufferSource buffers) {
        ExtendedItemRenderer.renderSkinInBox(bakedSkin, ColorScheme.EMPTY, ItemStack.f_41583_, x, y, z, width, height, rx, ry, rz, 0.0f, 0xF000F0, poseStack, buffers);
    }

    public static void renderSkinInBox(BakedSkin bakedSkin, ColorScheme scheme, ItemStack itemStack, float x, float y, float z, float width, float height, float rx, float ry, float rz, float partialTicks, int light, PoseStack poseStack, MultiBufferSource buffers) {
        if (bakedSkin != null) {
            int t = TickUtils.ticks();
            float si = Math.min(width, height);
            poseStack.m_85836_();
            poseStack.m_85837_((double)(x + width / 2.0f), (double)(y + height / 2.0f), (double)z);
            ABI.mulPoseMatrix(poseStack, OpenMatrix4f.createScaleMatrix(1.0f, -1.0f, 1.0f));
            ABI.mulPose(poseStack, Vector3f.XP.rotationDegrees(rx));
            ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(ry + (float)(t / 10 % 360)));
            poseStack.m_85841_(0.625f, 0.625f, 0.625f);
            poseStack.m_85841_(si, si, si);
            ExtendedItemRenderer.renderSkinInBox(bakedSkin, scheme, itemStack, null, Vector3f.ONE, 1.0f, 1.0f, 1.0f, partialTicks, light, poseStack, buffers);
            poseStack.m_85849_();
        }
    }

    public static void renderSkinInBox(BakedSkin bakedSkin, ColorScheme scheme, ItemStack itemStack, @Nullable Vector3f rotation, Vector3f scale, float targetWidth, float targetHeight, float targetDepth, float partialTicks, int light, PoseStack poseStack, MultiBufferSource buffers) {
        SkinRenderTesselator context = SkinRenderTesselator.create(bakedSkin);
        if (context == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        context.setLightmap(light);
        context.setPartialTicks(partialTicks);
        context.setRenderData(SkinRenderData.of((Entity)context.getMannequin()));
        context.setReference(itemStack, 0.0f, rotation);
        context.setColorScheme(scheme);
        Rectangle3f rect = context.getBakedRenderBounds();
        float newScale = Math.min(targetWidth / rect.getWidth(), targetHeight / rect.getHeight());
        newScale = Math.min(newScale, targetDepth / rect.getDepth());
        if (ModDebugger.targetBounds) {
            ShapeTesselator.stroke(-targetWidth / 2.0f, -targetHeight / 2.0f, -targetDepth / 2.0f, targetWidth / 2.0f, targetHeight / 2.0f, targetDepth / 2.0f, UIColor.ORANGE, poseStack, buffers);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, targetWidth, targetHeight, targetDepth, poseStack, buffers);
        }
        poseStack.m_85841_(newScale / scale.getX(), newScale / scale.getY(), newScale / scale.getZ());
        poseStack.m_85837_((double)(-rect.getMidX()), (double)(-rect.getMidY()), (double)(-rect.getMidZ()));
        context.draw(poseStack, buffers);
        poseStack.m_85849_();
    }

    public static void renderMannequin(PlayerTextureDescriptor descriptor, Vector3f rotation, Vector3f scale, float targetWidth, float targetHeight, float targetDepth, float partialTicks, int light, PoseStack poseStack, MultiBufferSource buffers) {
        MannequinEntity entity = SkinItemRenderer.getInstance().getMannequinEntity();
        if (entity == null || entity.m_9236_() == null) {
            return;
        }
        poseStack.m_85836_();
        ABI.mulPose(poseStack, Vector3f.YP.rotationDegrees(180.0f));
        if (!descriptor.equals(entity.getTextureDescriptor())) {
            entity.setTextureDescriptor(descriptor);
        }
        Rectangle3f rect = new Rectangle3f(entity.m_20191_());
        if (ModDebugger.targetBounds) {
            ShapeTesselator.stroke(-targetWidth / 2.0f, -targetHeight / 2.0f, -targetDepth / 2.0f, targetWidth / 2.0f, targetHeight / 2.0f, targetDepth / 2.0f, UIColor.ORANGE, poseStack, buffers);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, targetWidth, targetHeight, targetDepth, poseStack, buffers);
        }
        Rectangle3f resolvedRect = rect.offset(rect.getMidX(), rect.getMidY(), rect.getMidZ());
        resolvedRect.mul(new OpenMatrix4f(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true)));
        float newScale = Math.min(targetWidth / resolvedRect.getWidth(), targetHeight / resolvedRect.getHeight());
        poseStack.m_85841_(newScale, newScale, newScale);
        poseStack.m_85837_((double)(-rect.getMidX()), (double)(-rect.getMidY()), (double)(-rect.getMidZ()));
        EntityRenderDispatcher rendererManager = Minecraft.m_91087_().m_91290_();
        RenderSystem.m_69890_(() -> rendererManager.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, buffers, light));
        poseStack.m_85849_();
    }
}

