/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;

public class ExtendedFaceRenderer {
    private static final float[][] FACE_MARK_TEXTURES = new float[][]{{0.998f, 0.998f}, {0.998f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.998f}};
    private static final float[][][] FACE_MARK_VERTEXES = new float[][][]{new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}};

    public static void render(int x, int y, int z, Direction direction, IPaintColor paintColor, int alpha, int lightmap, int overlay, PoseStack poseStack, VertexConsumer builder) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        ISkinPaintType paintType = paintColor.getPaintType();
        float u = paintType.getU();
        float v = paintType.getV();
        int color = paintColor.getRGB();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = alpha & 0xFF;
        if (overlay != 0) {
            float q = (float)(overlay >> 24 & 0xFF) / 255.0f;
            r = ColorUtils.mix(r, overlay >> 16 & 0xFF, q);
            g = ColorUtils.mix(g, overlay >> 8 & 0xFF, q);
            b = ColorUtils.mix(b, overlay & 0xFF, q);
        }
        byte[][] vertexes = SkinUtils.FACE_VERTEXES[direction.m_122411_()];
        for (int i = 0; i < 4; ++i) {
            builder.m_85982_(pose, (float)(x + vertexes[i][0]), (float)(y + vertexes[i][1]), (float)(z + vertexes[i][2])).m_6122_(r, g, b, a).m_7421_((u + FACE_MARK_TEXTURES[i][0]) / 256.0f, (v + FACE_MARK_TEXTURES[i][1]) / 256.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_85977_(normal, (float)vertexes[4][0], (float)vertexes[4][1], (float)vertexes[4][2]).m_5752_();
        }
    }

    public static void renderMarker(int x, int y, int z, Direction direction, IPaintColor paintColor, int alpha, int light, int overlay, PoseStack poseStack, VertexConsumer builder) {
        if (paintColor.getPaintType() == SkinPaintTypes.NORMAL) {
            return;
        }
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        ISkinPaintType paintType = paintColor.getPaintType();
        int u = paintType.getIndex() % 8;
        int v = paintType.getIndex() / 8;
        float[][] vertexes = FACE_MARK_VERTEXES[direction.m_122411_()];
        for (int i = 0; i < 4; ++i) {
            builder.m_85982_(pose, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).m_6122_(255, 255, 255, alpha & 0xFF).m_7421_(((float)u + FACE_MARK_TEXTURES[i][0]) / 8.0f, ((float)v + FACE_MARK_TEXTURES[i][1]) / 8.0f).m_86008_(overlay).m_85969_(light).m_85977_(normal, vertexes[4][0], vertexes[4][1], vertexes[4][2]).m_5752_();
        }
    }

    public static void render2(int x, int y, int z, Direction direction, IPaintColor paintColor, int alpha, int light, int overlay, PoseStack poseStack, VertexConsumer builder) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        boolean u = false;
        boolean v = false;
        int color = paintColor.getRGB();
        float[][] vertexes = FACE_MARK_VERTEXES[direction.m_122411_()];
        for (int i = 0; i < 4; ++i) {
            builder.m_85982_(pose, (float)x + vertexes[i][0], (float)y + vertexes[i][1], (float)z + vertexes[i][2]).m_6122_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha & 0xFF).m_7421_((float)u + FACE_MARK_TEXTURES[i][0], (float)v + FACE_MARK_TEXTURES[i][1]).m_86008_(overlay).m_85969_(light).m_85977_(normal, vertexes[4][0], vertexes[4][1], vertexes[4][2]).m_5752_();
        }
    }
}

