/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.client.IRenderBufferObject;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderObject
implements IRenderBufferObject,
AutoCloseable {
    protected int id = -1;
    protected int size = 0;
    protected final AtomicInteger refCount = new AtomicInteger(1);

    public SkinRenderObject() {
        RenderSystem.m_69531_(id -> {
            this.id = id;
        });
    }

    public static void unbind() {
        RenderSystem.m_157208_((int)34962, () -> 0);
    }

    @Override
    public void bind() {
        RenderSystem.m_157208_((int)34962, () -> this.id);
    }

    public void upload(ByteBuffer byteBuffer) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.upload(byteBuffer));
            return;
        }
        if (this.id < 0) {
            return;
        }
        this.bind();
        this.size = byteBuffer.limit();
        RenderSystem.m_69525_((int)34962, (ByteBuffer)byteBuffer, (int)35044);
        SkinRenderObject.unbind();
    }

    void retain() {
        this.refCount.incrementAndGet();
    }

    void release() {
        int count = this.refCount.decrementAndGet();
        if (count <= 0) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.id < 0) {
            return;
        }
        int id = this.id;
        Minecraft.m_91087_().execute(() -> RenderSystem.m_69529_((int)id));
        this.id = -1;
        this.refCount.set(0);
    }
}

