/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.lang.reflect.Proxy;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedModelStorage {
    private static BakedModel SHARED_MODEL;
    final ItemStack itemStack;
    final EmbeddedSkinStack embeddedStack;
    final Level level;
    final LivingEntity entity;
    final BakedModel bakedModel;

    public BakedModelStorage(ItemStack itemStack, EmbeddedSkinStack embeddedStack, LivingEntity entity, @Nullable Level level, BakedModel bakedModel) {
        this.itemStack = itemStack;
        this.embeddedStack = embeddedStack;
        this.level = level;
        this.entity = entity;
        this.bakedModel = bakedModel;
    }

    @Nullable
    public static BakedModelStorage unwrap(BakedModel bakedModel) {
        if (bakedModel instanceof IAssociatedObjectProvider) {
            return (BakedModelStorage)((IAssociatedObjectProvider)bakedModel).getAssociatedObject();
        }
        return null;
    }

    public static BakedModel wrap(BakedModel bakedModel, ItemStack itemStack, EmbeddedSkinStack embeddedStack, LivingEntity entity, @Nullable Level level) {
        if (level == null) {
            bakedModel = BakedModelStorage.getSkinBakedModel();
        }
        Class[] classes = new Class[]{BakedModel.class, IAssociatedObjectProvider.class};
        BakedModelStorage storage = new BakedModelStorage(itemStack, embeddedStack, entity, level, bakedModel);
        return (BakedModel)Proxy.newProxyInstance(BakedModel.class.getClassLoader(), classes, (proxy, method, methodArgs) -> {
            if (method.getDeclaringClass() == IAssociatedObjectProvider.class) {
                return storage;
            }
            return method.invoke((Object)storage.bakedModel, methodArgs);
        });
    }

    public static BakedModel getSkinBakedModel() {
        if (SHARED_MODEL == null) {
            SHARED_MODEL = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(ModConstants.key("skin"), "inventory"));
        }
        return SHARED_MODEL;
    }

    public BakedModel getOriginModel() {
        return this.bakedModel;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public Level getLevel() {
        return this.level;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public EmbeddedSkinStack getEmbeddedStack() {
        return this.embeddedStack;
    }
}

