/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.library.ISkinLibraryListener;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.PackedQuad;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.data.DataTransformer;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.data.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class SkinBakery
implements ISkinLibraryListener {
    private static final SkinBakery EMPTY = new SkinBakery();
    private static SkinBakery BAKERY;
    private final AtomicInteger bakingQueue = new AtomicInteger(0);
    private final AtomicIntegerArray bakeTimes = new AtomicIntegerArray(1000);
    private final ArrayList<IBakeListener> listeners = new ArrayList();
    private final DataTransformer<String, BakedSkin, Skin> manager = new DataTransformer.Builder().thread("AW-SKIN-BK", 1).loadCount(ModConfig.Client.modelBakingThreadCount).transformCount(ModConfig.Client.modelBakingThreadCount).loader(this::safeLoadSkin2).transformer(this::safeBakeSkin2).build();

    public static SkinBakery getInstance() {
        if (BAKERY != null) {
            return BAKERY;
        }
        return EMPTY;
    }

    public static void start() {
        if (BAKERY == null) {
            BAKERY = new SkinBakery();
            BAKERY.startListenLibraryChanges();
            ModLog.debug("start bakery", new Object[0]);
        }
    }

    public static void stop() {
        if (BAKERY != null) {
            BAKERY.stopListenLibraryChanges();
            SkinBakery.BAKERY.manager.shutdown();
            BAKERY = null;
            SkinVertexBufferBuilder.clearAllCache();
            ModLog.debug("stop bakery", new Object[0]);
        }
    }

    public void addListener(IBakeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IBakeListener listener) {
        this.listeners.remove(listener);
    }

    @Nullable
    public BakedSkin getSkin(String identifier) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.get(identifier);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(String identifier, Ticket ticket) {
        if (identifier.isEmpty()) {
            return null;
        }
        Pair<BakedSkin, Exception> pair = this.manager.getOrLoad(identifier, ticket);
        if (pair != null) {
            return (BakedSkin)pair.getKey();
        }
        return null;
    }

    @Nullable
    public BakedSkin loadSkin(SkinDescriptor descriptor, Ticket ticket) {
        if (!descriptor.isEmpty()) {
            return this.loadSkin(descriptor.getIdentifier(), ticket);
        }
        return null;
    }

    public void loadSkin(String identifier, Ticket ticket, IResultHandler<BakedSkin> handler) {
        this.manager.load(identifier, ticket, handler);
    }

    private void startListenLibraryChanges() {
        SkinLibraryManager.getClient().addListener(this);
    }

    private void stopListenLibraryChanges() {
        SkinLibraryManager.getClient().removeListener(this);
    }

    @Override
    public void libraryDidChanges(ISkinLibrary library, ISkinLibrary.Difference difference) {
        RenderSystem.m_69879_(() -> {
            difference.getRemovedChanges().forEach(it -> this.manager.remove(it.getSkinIdentifier()));
            difference.getUpdatedChanges().forEach(it -> this.manager.remove(((ISkinLibrary.Entry)it.getKey()).getSkinIdentifier()));
        });
    }

    private void safeLoadSkin2(String identifier, IResultHandler<Skin> complete) {
        SkinLoader.getInstance().loadSkin(identifier, complete);
    }

    private void safeBakeSkin2(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        try {
            this.bakeSkin(identifier, skin, complete);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            complete.throwing(exception);
        }
    }

    private void bakeSkin(String identifier, Skin skin, IResultHandler<BakedSkin> complete) {
        ModLog.debug("'{}' => start baking skin", identifier);
        long startTime = System.currentTimeMillis();
        SkinUsedCounter usedCounter = new SkinUsedCounter();
        ArrayList<BakedSkinPart> bakedParts = new ArrayList<BakedSkinPart>();
        ColorScheme scheme = new ColorScheme();
        ColorDescriptor colorInfo = new ColorDescriptor();
        skin.getParts().forEach(part -> {
            PackedQuad.from(part).forEach((partType, quads) -> {
                SkinPart usedPart = part;
                if (usedPart.getType() != partType) {
                    usedPart = new SkinPart.Empty((ISkinPartType)partType, quads.getBounds(), quads.getRenderShape());
                }
                BakedSkinPart bakedPart = new BakedSkinPart(usedPart, (PackedQuad)quads);
                bakedParts.add(bakedPart);
                usedCounter.addFaceTotal(bakedPart.getFaceTotal());
            });
            usedCounter.add(part.getCubeData().getUsedCounter());
        });
        PackedQuad.from(skin.getPaintData()).forEach((partType, quads) -> {
            SkinPart.Empty part = new SkinPart.Empty((ISkinPartType)partType, quads.getBounds(), quads.getRenderShape());
            BakedSkinPart bakedPart = new BakedSkinPart(part, (PackedQuad)quads);
            bakedParts.add(bakedPart);
        });
        int partId = 0;
        ArrayList<BakedSkinPart> iterator = new ArrayList<BakedSkinPart>(bakedParts);
        while (!iterator.isEmpty()) {
            BakedSkinPart bakedPart = (BakedSkinPart)iterator.remove(0);
            bakedPart.setId(partId++);
            colorInfo.add(bakedPart.getColorInfo());
            iterator.addAll(0, bakedPart.getChildren());
        }
        usedCounter.addPaints(colorInfo.getPaintTypes());
        long totalTime = System.currentTimeMillis() - startTime;
        BakedSkin bakedSkin = new BakedSkin(identifier, skin, scheme, usedCounter, colorInfo, bakedParts);
        ModLog.debug("'{}' => accept baked skin, time: {}ms", identifier, totalTime);
        complete.accept(bakedSkin);
        RenderSystem.m_69879_(() -> this.notifyBake(identifier, bakedSkin));
        if (totalTime < 250L) {
            this.sleep(100L);
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyBake(String identifier, BakedSkin bakedSkin) {
        this.listeners.forEach(listener -> listener.didBake(identifier, bakedSkin));
    }

    public int getAverageBakeTime() {
        int totalItems = 0;
        int totalTime = 0;
        for (int i = 0; i < this.bakeTimes.length(); ++i) {
            int time = this.bakeTimes.get(i);
            if (time == 0) continue;
            ++totalItems;
            totalTime += time;
        }
        return (int)((double)totalTime / (double)totalItems);
    }

    public int getBakingQueueSize() {
        return this.bakingQueue.get();
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface IBakeListener {
        public void didBake(String var1, BakedSkin var2);
    }
}

