/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.api.client.IBakedSkin;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.data.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ModelHolder;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.client.model.Model;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin
implements IBakedSkin {
    private final int id = ThreadUtils.BAKED_SKIN_COUNTER.incrementAndGet();
    private final String identifier;
    private final Skin skin;
    private final HashMap<Object, Rectangle3f> cachedBounds = new HashMap();
    private final HashMap<BlockPos, Rectangle3i> cachedBlockBounds = new HashMap();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final ColorScheme preference;
    private final HashMap<Integer, ColorScheme> resolvedColorSchemes = new HashMap();

    public BakedSkin(String identifier, Skin skin, ColorScheme preference, SkinUsedCounter usedCounter, ColorDescriptor colorDescriptor, ArrayList<BakedSkinPart> bakedParts) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinParts = bakedParts;
        this.preference = preference;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.useTickRange = this.getUseTickRange(bakedParts);
        this.loadBlockBounds();
    }

    public ColorScheme resolve(Entity entity, ColorScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return ColorScheme.EMPTY;
        }
        ColorScheme resolvedColorScheme = this.resolvedColorSchemes.computeIfAbsent(entity.m_19879_(), k -> this.preference.copy());
        if (entity.m_19879_() != -1) {
            ResourceLocation resolvedTexture = PlayerTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.getTexture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int getId() {
        return this.id;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public ISkinType getType() {
        return this.skin.getType();
    }

    public List<BakedSkinPart> getSkinParts() {
        return this.skinParts;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        return this.cachedBlockBounds;
    }

    public Rectangle3f getRenderBounds(@Nullable Entity entity, @Nullable Model model, @Nullable Vector3f rotation, ItemStack itemStack) {
        Object key;
        Rectangle3f bounds;
        if (entity == null) {
            entity = SkinItemRenderer.getInstance().getMannequinEntity();
        }
        if (model == null) {
            model = SkinItemRenderer.getInstance().getMannequinModel();
        }
        if ((bounds = this.cachedBounds.get(key = SkinCache.borrowKey(model, rotation))) != null) {
            SkinCache.returnKey(key);
            return bounds;
        }
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape((Entity)entity, (Model)model, itemStack, AbstractItemTransformType.NONE);
        if (rotation != null) {
            matrix.rotate(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (rotation != null) {
            Vector4f center = new Vector4f(bounds.getCenter());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.getWidth() / 2.0f);
            bounds.setY(center.y() - bounds.getHeight() / 2.0f);
            bounds.setZ(center.z() - bounds.getDepth() / 2.0f);
        }
        this.cachedBounds.put(key, bounds);
        return bounds;
    }

    public OpenVoxelShape getRenderShape(Entity entity, Model model, ItemStack itemStack, AbstractItemTransformType transformType) {
        SkinRenderer<Entity, IModel> renderer = SkinRendererManager.getInstance().getRenderer(entity, model, null);
        if (renderer != null) {
            return this.getRenderShape((T)entity, (M)ModelHolder.ofNullable(model), itemStack, transformType, renderer);
        }
        return OpenVoxelShape.empty();
    }

    public <T extends Entity, M extends IModel> OpenVoxelShape getRenderShape(T entity, M model, ItemStack itemStack, AbstractItemTransformType transformType, SkinRenderer<T, M> renderer) {
        SkinRenderContext context = new SkinRenderContext(new PoseStack());
        context.setTransformType(transformType);
        context.setReference(0.0f, itemStack);
        context.setTransforms(entity, model);
        OpenVoxelShape shape = OpenVoxelShape.empty();
        for (BakedSkinPart bakedPart : this.skinParts) {
            this.addRenderShape(shape, entity, model, bakedPart, renderer, context);
        }
        return shape;
    }

    private <T extends Entity, M extends IModel> void addRenderShape(OpenVoxelShape shape, T entity, M model, BakedSkinPart part, SkinRenderer<T, M> renderer, SkinRenderContext context) {
        if (!renderer.prepare(entity, model, part, this, context)) {
            return;
        }
        OpenVoxelShape shape1 = part.getRenderShape().copy();
        context.pushPose();
        renderer.apply(entity, model, part, this, context);
        shape1.mul(context.pose().lastPose());
        shape.add(shape1);
        for (BakedSkinPart childPart : part.getChildren()) {
            this.addRenderShape(shape, entity, model, childPart, renderer, context);
        }
        context.popPose();
    }

    public <T extends Entity, V extends Model, M extends IModel> boolean shouldRenderPart(T entity, M model, BakedSkinPart bakedPart, SkinRenderContext context) {
        ISkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (this.isArrowEntity(entity)) {
                return true;
            }
            if (context.getTransformType() == AbstractItemTransformType.NONE) {
                return this.skinParts.size() == 1;
            }
            return false;
        }
        if (this.isArrowEntity(entity)) {
            return false;
        }
        if (partType instanceof ICanUse && entity instanceof LivingEntity) {
            int useTick = this.getUseTick((LivingEntity)entity, context.getReference());
            Range<Integer> useRange = ((ICanUse)((Object)partType)).getUseRange();
            return useRange.contains((Comparable)Integer.valueOf(MathUtils.clamp(useTick, (Integer)this.useTickRange.lowerEndpoint(), (Integer)this.useTickRange.upperEndpoint())));
        }
        return true;
    }

    private boolean isArrowEntity(Entity entity) {
        if (entity instanceof ThrownTrident) {
            return false;
        }
        return entity instanceof AbstractArrow;
    }

    private void loadBlockBounds() {
        if (this.skin.getType() != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : this.skinParts) {
            HashMap<BlockPos, Rectangle3i> bm = skinPart.getPart().getBlockBounds();
            if (bm == null) continue;
            this.cachedBlockBounds.putAll(bm);
        }
    }

    private int getUseTick(LivingEntity entity, ItemStack itemStack) {
        if (entity.m_21211_() == itemStack) {
            return entity.m_21252_();
        }
        if (CrossbowItem.m_40932_((ItemStack)itemStack)) {
            return 100;
        }
        return 0;
    }

    private Range<Integer> getUseTickRange(ArrayList<BakedSkinPart> bakedParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : bakedParts) {
            ISkinPartType partType = bakedPart.getType();
            if (!(partType instanceof ICanUse)) continue;
            Range<Integer> range = ((ICanUse)((Object)partType)).getUseRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakedSkin bakedSkin = (BakedSkin)o;
        return this.identifier.equals(bakedSkin.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

