/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import java.util.function.Supplier;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractForgeNetworkManager
extends NetworkEvent {
    public AbstractForgeNetworkManager() {
        super(() -> null);
    }

    public static void register(ResourceLocation channelName, String channelVersion, Object dispatcher) {
        EventNetworkChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channelName).networkProtocolVersion(() -> channelVersion).clientAcceptedVersions(sv -> true).serverAcceptedVersions(cv -> {
            if (ModConfig.Common.enableProtocolCheck) {
                return cv.equals(channelVersion);
            }
            return true;
        }).eventNetworkChannel();
        channel.registerObject(dispatcher);
    }

    public static PacketDistributor.PacketTarget server() {
        return PacketDistributor.SERVER.noArg();
    }

    public static PacketDistributor.PacketTarget allPlayers() {
        return PacketDistributor.ALL.noArg();
    }

    public static PacketDistributor.PacketTarget trackingEntityAndSelf(Supplier<Entity> supplier) {
        return PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier);
    }

    public static enum Direction {
        PLAY_TO_SERVER(NetworkDirection.PLAY_TO_SERVER),
        PLAY_TO_CLIENT(NetworkDirection.PLAY_TO_CLIENT);

        private final NetworkDirection networkDirection;

        private Direction(NetworkDirection networkDirection) {
            this.networkDirection = networkDirection;
        }

        public <T extends Packet<?>> ICustomPacket<T> buildPacket(Pair<FriendlyByteBuf, Integer> packetData, ResourceLocation channelName) {
            return this.networkDirection.buildPacket(packetData, channelName);
        }

        public void enqueueWork(Runnable runnable) {
            BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(this.networkDirection.getOriginationSide());
            executor.m_18689_(runnable);
        }
    }
}

