/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGGraphicsRenderer;
import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreenImpl;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AbstractGraphicsRenderer
implements CGGraphicsRenderer,
CGGraphicsState {
    private static final MultiBufferSource.BufferSource SHARED_BUFFERS = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
    private final PoseStack poseStack;
    private final CGPoint mousePos;
    private final float partialTicks;
    private final AbstractMenuScreenImpl<?> screen;
    private final Font font;
    private UIFont uifont;

    public AbstractGraphicsRenderer(AbstractMenuScreenImpl<?> screen, Font font, PoseStack poseStack, float mouseX, float mouseY, float partialTicks) {
        this.screen = screen;
        this.font = font;
        this.poseStack = poseStack;
        this.mousePos = new CGPoint(mouseX, mouseY);
        this.partialTicks = partialTicks;
    }

    public static PoseStack of(CGGraphicsContext context) {
        AbstractGraphicsRenderer impl = (AbstractGraphicsRenderer)ObjectUtils.unsafeCast(context.state());
        return impl.poseStack;
    }

    public static CGGraphicsContext of(AbstractMenuScreenImpl<?> screen, Font font, PoseStack poseStack, float mouseX, float mouseY, float partialTicks) {
        AbstractGraphicsRenderer impl = new AbstractGraphicsRenderer(screen, font, poseStack, mouseX, mouseY, partialTicks);
        return new CGGraphicsContext(impl, impl);
    }

    @Override
    public void renderTooltip(NSString text, CGRect rect, @Nullable UIFont font, CGGraphicsContext context) {
        if (font == null) {
            font = context.state().font();
        }
        List texts = font.impl().m_92923_((FormattedText)text.component(), 100000);
        this.screen._renderTooltip(this.poseStack, texts, (int)this.mousePos.getX(), (int)this.mousePos.getY());
    }

    @Override
    public void renderEntity(LivingEntity entity, int x, int y, int scale, float mouseX, float mouseY, CGGraphicsContext context) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166854_(this.poseStack.m_85850_().m_85861_());
        RenderSystem.m_157182_();
        InventoryScreen.m_98850_((int)x, (int)y, (int)scale, (float)mouseX, (float)mouseY, (LivingEntity)entity);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @Override
    public void renderItem(ItemStack itemStack, int x, int y, CGGraphicsContext context) {
        Minecraft.m_91087_().m_91291_().m_115218_(itemStack, x, y);
    }

    @Override
    public void flush() {
        SHARED_BUFFERS.m_109911_();
    }

    @Override
    public UIFont font() {
        if (this.uifont == null) {
            this.uifont = new UIFont(this.font, 9.0f);
        }
        return this.uifont;
    }

    @Override
    public CGPoint mousePos() {
        return this.mousePos;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    @Override
    public MultiBufferSource buffers() {
        return SHARED_BUFFERS;
    }

    @Override
    public PoseStack ctm() {
        return this.poseStack;
    }
}

