/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.OutfitMakerMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateOutfitMakerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateOutfitMakerPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.field = (Field)buffer.m_130066_(Field.class);
        this.fieldValue = this.field.getDataAccessor().dataSerializer.m_6709_(buffer);
    }

    public UpdateOutfitMakerPacket(OutfitMakerBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.field);
        this.field.getDataAccessor().dataSerializer.m_6856_(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockUtils.beginCombiner();
        this.accept2(packetHandler, player);
        BlockUtils.endCombiner();
    }

    private void accept2(IServerPacketHandler packetHandler, ServerPlayer player) {
        switch (this.field) {
            case ITEM_CRAFTING: {
                if (!ModPermissions.OUTFIT_MAKER_MAKE.accept((Player)player)) {
                    return;
                }
                if (!(player.f_36096_ instanceof OutfitMakerMenu)) break;
                CompoundTag nbt = (CompoundTag)this.fieldValue;
                GameProfile profile = DataSerializers.readGameProfile(nbt);
                ((OutfitMakerMenu)player.f_36096_).saveArmourItem((Player)player, profile);
                break;
            }
            case ITEM_NAME: 
            case ITEM_FLAVOUR: {
                BlockEntity entity = player.m_9236_().m_7702_(this.pos);
                if (!(entity instanceof OutfitMakerBlockEntity)) break;
                this.field.set((OutfitMakerBlockEntity)entity, this.fieldValue);
                break;
            }
        }
    }

    public static enum Field {
        ITEM_NAME(DataSerializers.STRING, OutfitMakerBlockEntity::getItemName, OutfitMakerBlockEntity::setItemName),
        ITEM_FLAVOUR(DataSerializers.STRING, OutfitMakerBlockEntity::getItemFlavour, OutfitMakerBlockEntity::setItemFlavour),
        ITEM_CRAFTING(DataSerializers.COMPOUND_TAG, null, null);

        private final DataAccessor<OutfitMakerBlockEntity, ?> dataAccessor;

        private <T> Field(IEntitySerializer<T> dataSerializer, Function<OutfitMakerBlockEntity, T> supplier, BiConsumer<OutfitMakerBlockEntity, T> applier) {
            this.dataAccessor = DataAccessor.of(dataSerializer, supplier, applier);
        }

        public <T> T get(OutfitMakerBlockEntity entity) {
            DataAccessor<OutfitMakerBlockEntity, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.get(entity);
        }

        public <T> void set(OutfitMakerBlockEntity entity, T value) {
            DataAccessor<OutfitMakerBlockEntity, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(entity, value);
        }

        public <T> DataAccessor<OutfitMakerBlockEntity, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }
    }
}

