/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.ColorMixerBlockEntity;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.utils.DataAccessor;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UpdateColorMixerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final Field field;
    private final Object fieldValue;

    public UpdateColorMixerPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.field = (Field)buffer.m_130066_(Field.class);
        this.fieldValue = this.field.getDataAccessor().dataSerializer.m_6709_(buffer);
    }

    public UpdateColorMixerPacket(ColorMixerBlockEntity entity, Field field, Object value) {
        this.pos = entity.m_58899_();
        this.field = field;
        this.fieldValue = value;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.field);
        this.field.getDataAccessor().dataSerializer.m_6856_(buffer, this.fieldValue);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        BlockEntity entity = player.m_9236_().m_7702_(this.pos);
        if (entity instanceof ColorMixerBlockEntity) {
            this.field.set((ColorMixerBlockEntity)entity, this.fieldValue);
        }
    }

    public static enum Field {
        COLOR(DataSerializers.PAINT_COLOR, ColorMixerBlockEntity::getColor, ColorMixerBlockEntity::setColor);

        private final DataAccessor<ColorMixerBlockEntity, ?> dataAccessor;

        private <T> Field(IEntitySerializer<T> dataSerializer, Function<ColorMixerBlockEntity, T> supplier, BiConsumer<ColorMixerBlockEntity, T> applier) {
            this.dataAccessor = DataAccessor.of(dataSerializer, supplier, applier);
        }

        public <T> T get(ColorMixerBlockEntity entity) {
            DataAccessor<ColorMixerBlockEntity, T> dataAccessor = this.getDataAccessor();
            return dataAccessor.get(entity);
        }

        public <T> void set(ColorMixerBlockEntity entity, T value) {
            DataAccessor<ColorMixerBlockEntity, T> dataAccessor = this.getDataAccessor();
            dataAccessor.set(entity, value);
        }

        public <T> DataAccessor<ColorMixerBlockEntity, T> getDataAccessor() {
            return (DataAccessor)ObjectUtils.unsafeCast(this.dataAccessor);
        }
    }
}

