/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.common.IItemParticleProvider;
import moe.plushie.armourers_workshop.api.common.IItemSoundProvider;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.api.painting.IPaintable;
import moe.plushie.armourers_workshop.builder.other.CubeApplier;
import moe.plushie.armourers_workshop.builder.other.CubePaintingEvent;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.utils.ext.OpenUseOnContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public class UpdateBlockColorPacket
extends CustomPacket {
    final InteractionHand hand;
    final GlobalPos clickedPos;
    final BlockHitResult traceResult;
    final CubePaintingEvent paintingEvent;

    public UpdateBlockColorPacket(FriendlyByteBuf buffer) {
        this.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        this.clickedPos = buffer.m_236872_();
        this.traceResult = buffer.m_130283_();
        this.paintingEvent = new CubePaintingEvent(buffer);
    }

    public UpdateBlockColorPacket(UseOnContext context, CubePaintingEvent paintingEvent) {
        this.hand = context.m_43724_();
        this.clickedPos = GlobalPos.m_122643_((ResourceKey)context.m_43725_().m_46472_(), (BlockPos)context.m_8083_());
        this.traceResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
        this.paintingEvent = paintingEvent;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.hand);
        buffer.m_236814_(this.clickedPos);
        buffer.m_130062_(this.traceResult);
        this.paintingEvent.encode(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        ServerLevel level = player.f_8924_.m_129880_(this.clickedPos.m_122640_());
        if (level == null) {
            return;
        }
        try {
            ItemStack itemStack = player.m_21120_(this.hand);
            OpenUseOnContext context = new OpenUseOnContext((Level)level, (Player)player, this.hand, itemStack, this.traceResult);
            CubeApplier applier = new CubeApplier((Level)level);
            this.paintingEvent.apply(applier, context);
            applier.submit(itemStack.m_41786_(), (Player)player);
            this.applyUseEffects(itemStack, context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BlockPos by(IPaintable target) {
        if (target instanceof BlockEntity) {
            return ((BlockEntity)target).m_58899_();
        }
        return null;
    }

    private void applyUseEffects(ItemStack itemStack, UseOnContext context) {
        Item item = itemStack.m_41720_();
        if (item instanceof IItemSoundProvider) {
            ((IItemSoundProvider)item).playSound(context);
        }
        if (item instanceof IItemParticleProvider) {
            ((IItemParticleProvider)item).playParticle(context);
        }
    }
}

