/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import java.util.HashMap;
import moe.plushie.armourers_workshop.builder.blockentity.AdvancedSkinBuilderBlockEntity;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedCameraPanel;
import moe.plushie.armourers_workshop.builder.client.gui.advancedskinbuilder.panel.AdvancedRightCardPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.Shortcut;
import moe.plushie.armourers_workshop.builder.menu.AdvancedSkinBuilderMenu;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedSkinBuilderWindow
extends MenuWindow<AdvancedSkinBuilderMenu> {
    private final AdvancedCameraPanel cameraView;
    private final AdvancedRightCardPanel rightCard;
    private final HashMap<Shortcut, Runnable> shortcuts = new HashMap();
    private int leftCardOffset = 100;
    private int rightCardOffset = 100;

    public AdvancedSkinBuilderWindow(AdvancedSkinBuilderMenu container, Inventory inventory, NSString title) {
        super(container, inventory, title);
        AdvancedSkinBuilderBlockEntity blockEntity = container.getBlockEntity(AdvancedSkinBuilderBlockEntity.class);
        this.cameraView = new AdvancedCameraPanel(blockEntity);
        this.rightCard = new AdvancedRightCardPanel(blockEntity, new CGRect(0.0f, 0.0f, 200.0f, UIScreen.bounds().getHeight() * 2.0f));
        this.inventoryView.setHidden(true);
        this.setup();
        this.cameraView.reset();
    }

    private void setup() {
        CGRect bounds = UIScreen.bounds();
        this.setFrame(bounds);
        this.setupCameraView();
        this.setupRightCard(bounds);
        this.setupShortcuts();
    }

    private void setupCameraView() {
        this.cameraView.setFrame(this.bounds());
        this.cameraView.setAutoresizingMask(18);
        this.addSubview(this.cameraView);
    }

    private void setupRightCard(CGRect rect) {
        this.rightCard.setAutoresizingMask(17);
        this.rightCard.setBackgroundColor(new UIColor(0x1D1D1D));
        this.rightCard.setTransform(CGAffineTransform.createScale(0.5f, 0.5f));
        this.rightCard.setFrame(new CGRect(rect.width - (float)this.rightCardOffset, 0.0f, this.rightCardOffset, rect.height));
        this.rightCard.setSkinTypeWithIndex(0);
        this.addSubview(this.rightCard);
    }

    private void setupShortcuts() {
        this.shortcuts.put(Shortcut.of("key.keyboard.control", "key.keyboard.1"), this::toggleLeftCard);
        this.shortcuts.put(Shortcut.of("key.keyboard.control", "key.keyboard.2"), this::toggleRightCard);
    }

    private void toggleLeftCard() {
        ModLog.debug("{}", "show left card");
    }

    private void toggleRightCard() {
        ModLog.debug("{}", "show right card");
        CGPoint oldValue = this.rightCard.center();
        CGPoint newValue = new CGPoint(oldValue.x + (float)this.rightCardOffset, oldValue.y);
        UIView.animationWithDuration(0.35, () -> this.rightCard.setCenter(newValue));
        this.rightCardOffset = -this.rightCardOffset;
    }

    @Override
    public void init() {
        super.init();
        this.cameraView.connect();
    }

    @Override
    public void deinit() {
        super.deinit();
        this.cameraView.disconnect();
    }

    @Override
    public void screenWillResize(CGSize size) {
        this.setFrame(new CGRect(0.0f, 0.0f, size.width, size.height));
    }

    @Override
    public void keyDown(UIEvent event) {
        super.keyDown(event);
        int key1 = event.key();
        int key2 = event.keyModifier();
        this.shortcuts.forEach((key, handler) -> {
            if (key.matches(key1, key2)) {
                handler.run();
            }
        });
    }

    @Override
    public boolean shouldRenderBackground() {
        return false;
    }
}

