/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.compatibility.core.AbstractHorizontalBlock;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.platform.MenuManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ArmourerBlock
extends AbstractHorizontalBlock
implements AbstractBlockEntityProvider {
    public ArmourerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockEntity createBlockEntity(BlockGetter level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.ARMOURER.get()).create(level, blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult traceResult) {
        return MenuManager.openMenu(ModMenuTypes.ARMOURER, level.m_7702_(blockPos), player);
    }

    public BlockState m_6843_(BlockState state, Rotation p_185499_2_) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror p_185471_2_) {
        return state;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
        this.applyTitleEntity(level, blockPos, te -> te.onPlace(level, blockPos, blockState, livingEntity));
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        this.applyTitleEntity(level, blockPos, te -> te.onRemove(level, blockPos, te.m_58900_()));
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }

    private void applyTitleEntity(Level level, BlockPos pos, Consumer<ArmourerBlockEntity> consumer) {
        ArmourerBlockEntity blockEntity = ObjectUtils.safeCast(level.m_7702_(pos), ArmourerBlockEntity.class);
        if (blockEntity != null) {
            consumer.accept(blockEntity);
        }
    }
}

