/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.api.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;

public interface IDataPackObject {
    public static IDataPackObject of(JsonElement element) {
        return () -> element;
    }

    default public Type type() {
        JsonElement object = this.jsonValue();
        if (object == null || object.isJsonNull()) {
            return Type.NULL;
        }
        if (object.isJsonObject()) {
            return Type.DICTIONARY;
        }
        if (object.isJsonArray()) {
            return Type.ARRAY;
        }
        if (object.isJsonPrimitive()) {
            JsonPrimitive primitive = object.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return Type.NUMBER;
            }
            if (primitive.isBoolean()) {
                return Type.BOOLEAN;
            }
            if (primitive.isString()) {
                return Type.STRING;
            }
        }
        return Type.NULL;
    }

    default public void add(Object value) {
    }

    default public IDataPackObject at(int index) {
        if (this.type() == Type.ARRAY) {
            return IDataPackObject.of(this.jsonValue().getAsJsonArray().get(index));
        }
        return IDataPackObject.of(null);
    }

    default public int size() {
        if (this.type() == Type.ARRAY) {
            return this.jsonValue().getAsJsonArray().size();
        }
        if (this.type() == Type.DICTIONARY) {
            return this.jsonValue().getAsJsonObject().size();
        }
        return 0;
    }

    default public void set(String key, Object value) {
    }

    default public IDataPackObject get(String key) {
        if (this.type() == Type.DICTIONARY) {
            return IDataPackObject.of(this.jsonValue().getAsJsonObject().get(key));
        }
        return IDataPackObject.of(null);
    }

    default public boolean has(String key) {
        if (this.type() == Type.DICTIONARY) {
            return this.jsonValue().getAsJsonObject().has(key);
        }
        return false;
    }

    default public Collection<String> allKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.type() == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> keys.add((String)it.getKey()));
        }
        return keys;
    }

    default public Collection<IDataPackObject> allValues() {
        Type type = this.type();
        ArrayList<IDataPackObject> values = new ArrayList<IDataPackObject>();
        if (type == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> values.add(IDataPackObject.of((JsonElement)it.getValue())));
        }
        if (type == Type.ARRAY) {
            this.jsonValue().getAsJsonArray().forEach(val -> values.add(IDataPackObject.of(val)));
        }
        return values;
    }

    default public Collection<Pair<String, IDataPackObject>> entrySet() {
        ArrayList<Pair<String, IDataPackObject>> keys = new ArrayList<Pair<String, IDataPackObject>>();
        if (this.type() == Type.DICTIONARY) {
            this.jsonValue().getAsJsonObject().entrySet().forEach(it -> keys.add(Pair.of((Object)((String)it.getKey()), (Object)IDataPackObject.of((JsonElement)it.getValue()))));
        }
        return keys;
    }

    default public boolean boolValue() {
        switch (this.type()) {
            case STRING: 
            case NUMBER: {
                return this.numberValue().intValue() != 0;
            }
            case BOOLEAN: {
                return this.jsonValue().getAsBoolean();
            }
        }
        return false;
    }

    default public Number numberValue() {
        switch (this.type()) {
            case STRING: 
            case NUMBER: {
                return this.jsonValue().getAsNumber();
            }
            case BOOLEAN: {
                if (this.jsonValue().getAsBoolean()) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    default public int intValue() {
        return this.numberValue().intValue();
    }

    default public float floatValue() {
        return this.numberValue().floatValue();
    }

    default public String stringValue() {
        switch (this.type()) {
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                return this.jsonValue().getAsString();
            }
        }
        return "";
    }

    default public void ifPresent(Consumer<IDataPackObject> consumer) {
        if (this.type() != Type.NULL) {
            consumer.accept(this);
        }
    }

    public JsonElement jsonValue();

    public static enum Type {
        NULL,
        BOOLEAN,
        NUMBER,
        STRING,
        ARRAY,
        DICTIONARY;

    }
}

