/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UILabelDelegate;
import com.apple.library.uikit.UIView;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UILabel
extends UIView {
    private UIColor textColor;
    private UIColor shadowColor;
    private NSTextAlignment.Horizontal textHorizontalAlignment = NSTextAlignment.Horizontal.LEFT;
    private NSTextAlignment.Vertical textVerticalAlignment = NSTextAlignment.Vertical.CENTER;
    protected final DelegateImpl<UILabelDelegate> delegate = DelegateImpl.of(new UILabelDelegate(){});
    private int numberOfLines = 1;
    private int lineSpacing = 0;
    private NSString text;
    private List<TextLine> cachedTextLines;
    private float cachedTextWidth;
    private float cachedTextHeight;
    private UIFont font;

    public UILabel(CGRect frame) {
        super(frame);
        this.setUserInteractionEnabled(false);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        Map<String, ?> attributes = this.attributesAtPoint(event.locationInView(this));
        if (attributes != null) {
            this.delegate.invoker().labelWillClickAttributes(this, attributes);
        }
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        if (this.text == null) {
            return;
        }
        UIFont font = this.font != null ? this.font : context.state().font();
        CGRect rect = this.bounds();
        this.remakeTextLineIfNeeded(this.text, font, rect);
        if (this.cachedTextLines == null || this.cachedTextLines.isEmpty()) {
            return;
        }
        float dy = this.sel(rect, this.cachedTextHeight, this.textVerticalAlignment);
        for (TextLine line : this.cachedTextLines) {
            CGPoint offset = line.offset;
            float dx = this.sel(rect, line.size.width, this.textHorizontalAlignment);
            context.drawText(line.text, offset.x + dx, offset.y + dy, font, this.textColor, this.shadowColor);
        }
    }

    public NSString text() {
        return this.text;
    }

    public void setText(NSString text) {
        this.text = text;
        this.setNeedsRemakeTextLine();
    }

    public UIColor textColor() {
        return this.textColor;
    }

    public void setTextColor(UIColor textColor) {
        this.textColor = textColor;
    }

    public UIColor shadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(UIColor shadowColor) {
        this.shadowColor = shadowColor;
    }

    public NSTextAlignment.Horizontal textHorizontalAlignment() {
        return this.textHorizontalAlignment;
    }

    public void setTextHorizontalAlignment(NSTextAlignment.Horizontal textHorizontalAlignment) {
        this.textHorizontalAlignment = textHorizontalAlignment;
    }

    public NSTextAlignment.Vertical textVerticalAlignment() {
        return this.textVerticalAlignment;
    }

    public void setTextVerticalAlignment(NSTextAlignment.Vertical textVerticalAlignment) {
        this.textVerticalAlignment = textVerticalAlignment;
    }

    public UIFont font() {
        return this.font;
    }

    public void setFont(UIFont font) {
        this.font = font;
        this.setNeedsRemakeTextLine();
    }

    public int numberOfLines() {
        return this.numberOfLines;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
        this.setNeedsRemakeTextLine();
    }

    public int lineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.setNeedsRemakeTextLine();
    }

    public UILabelDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(UILabelDelegate delegate) {
        this.delegate.set(delegate);
    }

    @Nullable
    public Map<String, ?> attributesAtPoint(CGPoint point) {
        if (this.cachedTextLines == null) {
            return null;
        }
        CGRect rect = this.bounds();
        float dy = this.sel(rect, this.cachedTextHeight, this.textVerticalAlignment);
        for (TextLine line : this.cachedTextLines) {
            CGPoint offset = line.offset;
            float dx = this.sel(rect, line.size.width, this.textHorizontalAlignment);
            if (!(point.y >= offset.y + dy) || !(point.y <= offset.y + dy + line.size.height)) continue;
            float ptx = point.x - dx;
            return line.text.attributes((int)ptx, line.font);
        }
        return null;
    }

    private float sel(CGRect rect, float value, NSTextAlignment.Vertical alignment) {
        switch (alignment) {
            case BOTTOM: {
                return rect.height - value;
            }
            case CENTER: {
                return (rect.height - value) / 2.0f;
            }
        }
        return 0.0f;
    }

    private float sel(CGRect rect, float value, NSTextAlignment.Horizontal alignment) {
        switch (alignment) {
            case RIGHT: {
                return rect.width - value;
            }
            case CENTER: {
                return (rect.width - value) / 2.0f;
            }
        }
        return 0.0f;
    }

    private void setNeedsRemakeTextLine() {
        this.cachedTextLines = null;
    }

    private void remakeTextLineIfNeeded(NSString title, UIFont font, CGRect bounds) {
        float width = bounds.width;
        if (this.cachedTextLines != null && this.cachedTextWidth == width) {
            return;
        }
        LinkedList<NSString> lines = new LinkedList<NSString>();
        if (this.numberOfLines == 1) {
            lines.add(title);
        } else {
            lines.addAll(title.split((int)width, font));
        }
        while (this.numberOfLines != 0 && lines.size() > this.numberOfLines) {
            lines.removeLast();
        }
        this.cachedTextLines = ObjectUtilsImpl.map(lines, text -> new TextLine((NSString)text, font));
        this.cachedTextWidth = width;
        int textHeight = 0;
        for (TextLine line : this.cachedTextLines) {
            line.offset = new CGPoint(0.0f, textHeight);
            textHeight = (int)((float)textHeight + (line.size.height + (float)this.lineSpacing));
        }
        if (!this.cachedTextLines.isEmpty()) {
            textHeight -= this.lineSpacing;
        }
        this.cachedTextHeight = textHeight;
    }

    protected static class TextLine {
        CGPoint offset;
        CGRect size;
        NSString text;
        UIFont font;

        TextLine(NSString text, UIFont font) {
            this.text = text;
            this.size = text.boundingRectWithFont(font);
            this.font = font;
        }
    }
}

