/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.impl.KeyboardManagerImpl;
import com.apple.library.impl.LayoutManagerImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.impl.StateValueImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEdgeInsets;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import java.util.Objects;

public class UIButton
extends UIControl {
    private final StateValueImpl<NSString> titleContainer = new StateValueImpl();
    private final StateValueImpl<UIColor> titleColorContainer = new StateValueImpl();
    private final StateValueImpl<UIImage> imageContainer = new StateValueImpl();
    private final StateValueImpl<UIImage> backgroundImageContainer = new StateValueImpl();
    private final StateValueImpl<NSString> tooltipContainer = new StateValueImpl();
    private final UILabel titleView = new UILabel(CGRect.ZERO);
    private final UIImageView imageView = new UIImageView(CGRect.ZERO);
    private UIEdgeInsets contentEdgeInsets = UIEdgeInsets.ZERO;
    private UIEdgeInsets imageEdgeInsets = UIEdgeInsets.ZERO;
    private UIEdgeInsets titleEdgeInsets = UIEdgeInsets.ZERO;
    private NSTextAlignment.Horizontal horizontalAlignment = NSTextAlignment.Horizontal.CENTER;
    private NSTextAlignment.Vertical verticalAlignment = NSTextAlignment.Vertical.CENTER;
    private CGRect cachedIconRect;
    private CGRect cachedTitleRect;
    private NSString cachedCurrentTitle;
    private UIImage cachedCurrentImage;
    private boolean shouldPassHighlighted = true;
    private boolean canBecomeFocused = true;

    public UIButton(CGRect frame) {
        super(frame);
        this.titleView.setShadowColor(UIColor.GRAY);
        this.titleView.setHidden(true);
        this.imageView.setHidden(true);
        this.addSubview(this.titleView);
        this.addSubview(this.imageView);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        SoundManagerImpl.click();
    }

    @Override
    public void keyDown(UIEvent event) {
        super.keyDown(event);
        if (this.isFocused() && this.isDownKey(event.key)) {
            this.sendEvent(UIControl.Event.MOUSE_LEFT_DOWN);
            SoundManagerImpl.click();
        }
    }

    @Override
    public void focusesDidChange() {
        super.focusesDidChange();
        this.updateStateIfNeeded();
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        this.remakeContentLayoutIfNeeded(context.state().font());
        context.drawImage(this.backgroundImageContainer.currentValue(), this.bounds());
    }

    public UIImage image(int state) {
        return this.imageContainer.valueForState(state);
    }

    public void setImage(UIImage image, int state) {
        this.imageContainer.setValueForState(image, state);
        this.applyImageToAnother(this.imageContainer, image, state);
        this.updateStateIfNeeded();
    }

    public UIImage backgroundImage(int state) {
        return this.backgroundImageContainer.valueForState(state);
    }

    public void setBackgroundImage(UIImage image, int state) {
        this.backgroundImageContainer.setValueForState(image, state);
        this.applyImageToAnother(this.backgroundImageContainer, image, state);
        this.updateStateIfNeeded();
    }

    public NSString title(int state) {
        return this.titleContainer.valueForState(state);
    }

    public void setTitle(NSString title, int state) {
        this.titleContainer.setValueForState(title, state);
        this.updateStateIfNeeded();
    }

    public UIColor titleColor(int state) {
        return this.titleColorContainer.valueForState(state);
    }

    public void setTitleColor(UIColor textColor, int state) {
        this.titleColorContainer.setValueForState(textColor, state);
        this.updateStateIfNeeded();
    }

    public NSString tooltip(int state) {
        return this.tooltipContainer.valueForState(state);
    }

    public void setTooltip(NSString tooltip, int state) {
        this.tooltipContainer.setValueForState(tooltip, state);
    }

    public UIEdgeInsets imageEdgeInsets() {
        return this.imageEdgeInsets;
    }

    public void setImageEdgeInsets(UIEdgeInsets imageEdgeInsets) {
        this.imageEdgeInsets = imageEdgeInsets;
        this.cachedIconRect = null;
    }

    public UIEdgeInsets titleEdgeInsets() {
        return this.titleEdgeInsets;
    }

    public void setTitleEdgeInsets(UIEdgeInsets titleEdgeInsets) {
        this.titleEdgeInsets = titleEdgeInsets;
        this.cachedIconRect = null;
    }

    public UIEdgeInsets contentEdgeInsets() {
        return this.contentEdgeInsets;
    }

    public void setContentEdgeInsets(UIEdgeInsets contentEdgeInsets) {
        this.contentEdgeInsets = contentEdgeInsets;
        this.cachedIconRect = null;
    }

    public NSTextAlignment.Horizontal horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(NSTextAlignment.Horizontal horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.setNeedsRemakeLayouts();
    }

    public NSTextAlignment.Vertical verticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(NSTextAlignment.Vertical verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        this.setNeedsRemakeLayouts();
    }

    public UILabel titleView() {
        return this.titleView;
    }

    public UIImageView imageView() {
        return this.imageView;
    }

    @Override
    public boolean canBecomeFocused() {
        return !this._ignoresTouchEvents(this) && this.isEnabled() && this.canBecomeFocused;
    }

    public void setCanBecomeFocused(boolean canBecomeFocused) {
        this.canBecomeFocused = canBecomeFocused;
    }

    @Override
    public boolean shouldPassHighlighted() {
        return this.shouldPassHighlighted;
    }

    public void setShouldPassHighlighted(boolean shouldPassHighlighted) {
        this.shouldPassHighlighted = shouldPassHighlighted;
    }

    private void setNeedsRemakeLayouts() {
        this.cachedTitleRect = null;
        this.cachedIconRect = null;
    }

    private void remakeContentLayoutIfNeeded(UIFont font) {
        if (this.cachedIconRect != null && this.cachedTitleRect != null) {
            return;
        }
        LayoutManagerImpl manager = new LayoutManagerImpl();
        manager.add(this.imageSize(this.imageContainer.currentValue()), this.imageEdgeInsets, size -> new CGRect(CGPoint.ZERO, (CGSize)size));
        manager.add(this.titleContainer.currentValue(), this.titleEdgeInsets, text -> text.boundingRectWithFont(font).offset(0.0f, 1.0f));
        manager.applyHorizontalLayout(this.bounds().insetBy(this.contentEdgeInsets), this.horizontalAlignment, this.verticalAlignment);
        this.cachedIconRect = manager.getOrDefault(0, CGRect.ZERO);
        if (this.cachedIconRect != null) {
            this.imageView.setFrame(this.cachedIconRect);
        }
        this.cachedTitleRect = manager.getOrDefault(1, CGRect.ZERO);
        if (this.cachedTitleRect != null) {
            this.titleView.setFrame(this.cachedTitleRect);
        }
    }

    @Override
    protected void updateStateIfNeeded() {
        int state = 0;
        if (this.isSelected()) {
            state |= 2;
        }
        if (this.isHighlighted()) {
            state |= 1;
        }
        if (this.isFocused()) {
            state |= 1;
        }
        if (!this.isEnabled()) {
            state |= 4;
        }
        this.imageContainer.setCurrentState(state);
        this.backgroundImageContainer.setCurrentState(state);
        this.titleContainer.setCurrentState(state);
        this.titleColorContainer.setCurrentState(state);
        this.tooltipContainer.setCurrentState(state);
        NSString currentTitle = this.titleContainer.currentValue();
        this.titleView.setTextColor(this.titleColorContainer.currentValue());
        if (!Objects.equals(currentTitle, this.cachedCurrentTitle)) {
            this.titleView.setText(currentTitle);
            this.titleView.setHidden(currentTitle == null);
            this.setNeedsRemakeLayouts();
        }
        UIImage currentImage = this.imageContainer.currentValue();
        this.imageView.setImage(currentImage);
        if (!Objects.equals(this.imageSize(currentImage), this.imageSize(this.cachedCurrentImage))) {
            this.imageView.setHidden(currentImage == null);
            this.setNeedsRemakeLayouts();
        }
        if (!this.tooltipContainer.isEmpty()) {
            this.setTooltip(this.tooltipContainer.currentValue());
        }
        this.cachedCurrentTitle = currentTitle;
        this.cachedCurrentImage = currentImage;
    }

    private CGSize imageSize(UIImage image) {
        if (image != null) {
            return image.size();
        }
        return null;
    }

    private boolean isDownKey(int key) {
        return KeyboardManagerImpl.isEnter(key) || KeyboardManagerImpl.isSpace(key);
    }

    private void applyImageToAnother(StateValueImpl<UIImage> container, UIImage image, int state) {
        if (state != 7 || image == null || !image.isPacked()) {
            return;
        }
        for (int nextState = 0; nextState < 7; ++nextState) {
            UIImage image1 = image.imageAtIndex(nextState);
            if (image1 == image) continue;
            container.setValueForState(image1, nextState);
        }
    }
}

