/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.tile_entity;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.TileEntities;

public class TileEntityMusicBox
extends BlockEntity {
    private boolean isPlaying = false;
    private boolean oldPoweredState = false;
    private boolean isPowering = false;
    private boolean firstBlockUpdate = true;
    private ItemStack noteStack = ItemStack.f_41583_;
    private IItemInstrument instrument;
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private byte mBPS;
    private float mVolume;
    private int poweringAge = 0;
    private int playingAge = 0;
    private int mLengthBeats = 0;
    private SoundController soundController = null;

    public TileEntityMusicBox(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)TileEntities.MUSIC_BOX.get(), blockPos, blockState);
        if (((Boolean)blockState.m_61143_((Property)BlockMusicBox.POWERED)).booleanValue()) {
            this.oldPoweredState = true;
        }
    }

    public void m_183515_(@NotNull CompoundTag parent) {
        IItemInstrument iItemInstrument;
        super.m_183515_(parent);
        if (!this.noteStack.m_41619_()) {
            CompoundTag noteTag = new CompoundTag();
            this.noteStack.m_41739_(noteTag);
            parent.m_128365_("note", (Tag)noteTag);
        }
        if (this.instrument != null && (iItemInstrument = this.instrument) instanceof Item) {
            Item item = (Item)iItemInstrument;
            ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)item);
            parent.m_128359_("instrument_id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        }
    }

    public void m_142466_(@NotNull CompoundTag parent) {
        super.m_142466_(parent);
        if (parent.m_128425_("note", 10)) {
            CompoundTag noteTag = parent.m_128469_("note");
            ItemStack note = ItemStack.m_41712_((CompoundTag)noteTag);
            this.setNoteStack(note, false);
        }
        if (parent.m_128425_("instrument_id", 8)) {
            this.setInstrument((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parent.m_128461_("instrument_id"))));
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    private void stopPowering() {
        BlockState state = this.m_58900_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(false)));
        }
        this.isPowering = false;
        this.poweringAge = 0;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, TileEntityMusicBox t) {
        CompoundTag comp;
        if (level != null && !t.noteStack.m_41619_() && t.notes.isEmpty() && t.noteStack.m_41782_() && (comp = t.noteStack.m_41783_()) != null && comp.m_128441_("id") && comp.m_128441_("ver") && comp.m_128441_("bps") && comp.m_128441_("l")) {
            UUID id = comp.m_128342_("id");
            int ver = comp.m_128451_("ver");
            if (level.f_46443_) {
                MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                    MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                    if (data != null) {
                        t.notes.clear();
                        t.notes.addAll(data.notes);
                    }
                });
            } else {
                MusicManager.MusicData data = MusicManager.getMusicData(id, ver, Objects.requireNonNull(level.m_7654_()));
                if (data != null) {
                    t.notes.clear();
                    t.notes.addAll(data.notes);
                }
            }
        }
        if (t.isPowering) {
            if (t.poweringAge >= 10) {
                t.stopPowering();
                return;
            }
            ++t.poweringAge;
        }
        if (t.noteStack.m_41619_() || t.instrument == null) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.isPlaying = false;
            return;
        }
        if (((Boolean)state.m_61143_((Property)BlockMusicBox.POWERED)).booleanValue()) {
            if (!t.oldPoweredState) {
                t.isPlaying = !t.isPlaying;
                t.poweringAge = 0;
                t.oldPoweredState = true;
                t.playingAge = 0;
                if (t.isPlaying) {
                    TileEntityMusicBox.musicStart(t, blockPos);
                } else if (t.soundController != null) {
                    t.soundController.setStop();
                }
            }
        } else if (t.oldPoweredState) {
            t.oldPoweredState = false;
        }
        if (t.isPlaying) {
            ++t.playingAge;
            if (t.playingAge >= t.beatsToTicks(t.mLengthBeats)) {
                TileEntityMusicBox.musicOver(t, state);
            }
        }
    }

    private int beatsToTicks(int beats) {
        return Math.round((float)beats * 20.0f / (float)this.mBPS);
    }

    public static void musicOver(TileEntityMusicBox t, BlockState state) {
        t.poweringAge = 0;
        t.isPlaying = false;
        t.isPowering = true;
        if (t.f_58857_ != null) {
            Direction rightSide = ((Direction)state.m_61143_((Property)BlockMusicBox.f_54117_)).m_122427_();
            t.f_58857_.m_46597_(t.f_58858_, (BlockState)state.m_61124_((Property)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(true)));
            BlockPos neighbor = t.f_58858_.m_121945_(rightSide);
            t.f_58857_.m_46586_(neighbor, t.m_58900_().m_60734_(), t.f_58858_);
            t.f_58857_.m_46590_(neighbor, t.m_58900_().m_60734_(), rightSide.m_122424_());
        }
    }

    public static void musicStart(TileEntityMusicBox t, BlockPos blockPos) {
        if (t.f_58857_ != null && t.f_58857_.f_46443_) {
            if (t.soundController != null) {
                t.soundController.setStop();
            }
            t.soundController = new SoundController(t.notes, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), t.instrument, t.mBPS, t.mVolume, t);
            t.soundController.start();
        }
    }

    public ItemStack getNoteStack() {
        return this.noteStack;
    }

    public void setNoteStack(ItemStack noteStack, boolean updateClient) {
        if (noteStack.m_41720_() instanceof ItemMusicSheet) {
            if (updateClient && this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.updateClient(noteStack, (Item)this.instrument);
            }
            this.noteStack = noteStack;
            if (noteStack.m_41782_() && noteStack.m_41783_() != null && noteStack.m_41783_().m_128441_("id") && noteStack.m_41783_().m_128441_("ver") && noteStack.m_41783_().m_128441_("l")) {
                CompoundTag comp = noteStack.m_41783_();
                this.mBPS = (byte)(comp.m_128441_("bps") ? (int)comp.m_128445_("bps") : 8);
                this.mVolume = comp.m_128441_("vol") ? comp.m_128457_("vol") : 1.0f;
                this.mLengthBeats = comp.m_128451_("l");
            } else {
                this.notes.clear();
            }
            this.m_6596_();
        }
    }

    public void removeNoteStack() {
        if (!this.noteStack.m_41619_()) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.updateClient(ItemStack.f_41583_, (Item)this.instrument);
            }
            this.noteStack = ItemStack.f_41583_;
            this.notes.clear();
            this.m_6596_();
        }
    }

    public IItemInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Item instrument) {
        if (instrument instanceof IItemInstrument) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.updateClient(null, instrument);
            }
            this.instrument = (IItemInstrument)instrument;
            this.m_6596_();
        }
    }

    public void removeInstrument() {
        if (this.instrument != null) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.updateClient(null, null);
            }
            this.instrument = null;
            this.m_6596_();
        }
    }

    private void updateClient(ItemStack noteStack, Item itemInstrument) {
        MusicBoxUpdatePacket packet = new MusicBoxUpdatePacket(this.f_58858_, noteStack, itemInstrument);
        if (this.f_58857_ != null) {
            XercaMusic.NETWORK_HANDLER.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)this.f_58857_.m_46865_(this.f_58858_)), (Object)packet);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        if (this.firstBlockUpdate) {
            this.firstBlockUpdate = false;
            if (this.f_58857_ != null && ((Boolean)this.m_58900_().m_61143_((Property)BlockMusicBox.POWERING)).booleanValue()) {
                this.stopPowering();
            }
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }
        return null;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
            if (this.f_58857_ != null && ((Boolean)this.m_58900_().m_61143_((Property)BlockMusicBox.POWERING)).booleanValue()) {
                this.stopPowering();
            }
        }
    }

    public void m_7651_() {
        if (this.soundController != null) {
            this.soundController.setStop();
        }
        super.m_7651_();
    }
}

