/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class WrenchItem
extends Item {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public WrenchItem(Item.Properties pProperties) {
        super(pProperties);
        this.attackDamage = 2.5f;
        float pAttackSpeedModifier = -2.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @PlatformOnly(value={"forge"})
    public float getDamage() {
        return this.attackDamage;
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_151052_);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.f_19853_.m_6269_(null, (Entity)pTarget, SoundEvents.f_11669_, SoundSource.NEUTRAL, 0.5f, 1.8f);
        pStack.m_41622_(1, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            boolean shiftDown;
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            if (CompatHandler.FLAN && !FlanCompat.canPlace(player, pos)) {
                return InteractionResult.FAIL;
            }
            ItemStack itemstack = context.m_43722_();
            Direction dir = context.m_43719_();
            Optional<Direction> success = BlockUtil.tryRotatingBlockAndConnected(dir, shiftDown = player.m_6144_(), pos, level, context.m_43720_());
            if (success.isPresent()) {
                dir = success.get();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, itemstack);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                } else {
                    WrenchItem.playTurningEffects(pos, shiftDown, dir, level, player);
                }
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (level.f_46443_) {
                level.m_6269_(context.m_43723_(), (Entity)player, SoundEvents.f_144232_, SoundSource.PLAYERS, 1.4f, 0.8f);
            }
        }
        return InteractionResult.FAIL;
    }

    public static void playTurningEffects(BlockPos pos, boolean shiftDown, Direction dir, Level level, Player player) {
        if (ClientConfigs.Items.WRENCH_PARTICLES.get().booleanValue()) {
            if (dir == Direction.DOWN) {
                shiftDown = !shiftDown;
            }
            level.m_7106_((ParticleOptions)ModParticles.ROTATION_TRAIL_EMITTER.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)dir.m_122411_(), 0.71, shiftDown ? 1.0 : -1.0);
        }
        level.m_5594_(player, pos, SoundEvents.f_12017_, SoundSource.BLOCKS, 1.0f, 0.6f);
        level.m_6269_(player, (Entity)player, SoundEvents.f_144231_, SoundSource.PLAYERS, 1.0f, 1.4f);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand pUsedHand) {
        if (entity instanceof ArmorStand || entity.m_6095_().m_204039_(ModTags.ROTATABLE)) {
            boolean shiftDown = player.m_6144_();
            float inc = 22.5f * (float)(shiftDown ? -1 : 1);
            entity.m_146922_(entity.m_146908_() + inc);
            if (player.f_19853_.f_46443_) {
                WrenchItem.playTurningEffects(entity.m_20097_().m_7494_(), shiftDown, Direction.UP, player.f_19853_, player);
            }
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(pUsedHand));
            return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

