/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.present;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface IPresentItemBehavior {
    default public ItemStack trigger(BlockSource pSource, ItemStack pStack) {
        ItemStack itemstack = this.performSpecialAction(pSource, pStack).orElseGet(() -> this.spitItem(pSource, pStack));
        this.playAnimation(pSource);
        return itemstack;
    }

    public Optional<ItemStack> performSpecialAction(BlockSource var1, ItemStack var2);

    private ItemStack spitItem(BlockSource pSource, ItemStack pStack) {
        ItemStack itemstack = pStack.m_41620_(1);
        IPresentItemBehavior.spawnItem((Level)pSource.m_7727_(), itemstack, 7.0, pSource);
        return pStack;
    }

    public static void spawnItem(Level pLevel, ItemStack pStack, double pSpeed, BlockSource source) {
        Position p = IPresentItemBehavior.getDispensePosition(source);
        ItemEntity itementity = new ItemEntity(pLevel, p.m_7096_(), p.m_7098_(), p.m_7094_(), pStack);
        itementity.m_20334_(pLevel.f_46441_.m_188583_() * 0.0075 * pSpeed, pLevel.f_46441_.m_188583_() * 0.0075 * pSpeed + 0.3, pLevel.f_46441_.m_188583_() * 0.0075 * pSpeed);
        pLevel.m_7967_((Entity)itementity);
    }

    default public void playAnimation(BlockSource pSource) {
        ServerLevel level = pSource.m_7727_();
        BlockPos pos = pSource.m_7961_();
        level.m_7696_(pos, pSource.m_6414_().m_60734_(), 0, 0);
    }

    public static Position getDispensePosition(BlockSource source) {
        double d0 = source.m_7096_();
        double d1 = source.m_7098_() + 0.125 + 1.0E-4;
        double d2 = source.m_7094_();
        return new PositionImpl(d0, d1, d2);
    }
}

