/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrain;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;

public class SmartBrainProvider<E extends LivingEntity>
extends Brain.Provider<E> {
    private static final Map<EntityType<? extends LivingEntity>, ImmutableList<MemoryModuleType<?>>> BRAIN_MEMORY_CACHE = new Object2ObjectOpenHashMap();
    private final E owner;
    private final boolean saveMemories;
    private final boolean nonStaticMemories;

    public SmartBrainProvider(E owner) {
        this(owner, false);
    }

    public SmartBrainProvider(E owner, boolean nonStaticMemories) {
        this(owner, false, nonStaticMemories);
    }

    public SmartBrainProvider(E owner, boolean saveMemories, boolean nonStaticMemories) {
        super(List.of(), List.of());
        this.owner = owner;
        this.saveMemories = saveMemories;
        this.nonStaticMemories = nonStaticMemories;
    }

    public final SmartBrain<E> makeBrain(Dynamic<?> codecLoader) {
        Object memories;
        List sensors = ((SmartBrainOwner)this.owner).getSensors();
        List<BrainActivityGroup<E>> taskList = this.compileTasks();
        if (!this.nonStaticMemories && BRAIN_MEMORY_CACHE.containsKey(this.owner.m_6095_())) {
            memories = BRAIN_MEMORY_CACHE.get(this.owner.m_6095_());
        } else {
            memories = this.createMemoryList(taskList, sensors);
            if (!this.nonStaticMemories) {
                BRAIN_MEMORY_CACHE.put((EntityType<LivingEntity>)((EntityType<? extends LivingEntity>)this.owner.m_6095_()), (ImmutableList<MemoryModuleType<?>>)memories);
            }
        }
        SmartBrain brain = new SmartBrain((List<MemoryModuleType<?>>)memories, sensors, taskList, this.saveMemories);
        this.finaliseBrain(brain);
        return brain;
    }

    private ImmutableList<MemoryModuleType<?>> createMemoryList(List<BrainActivityGroup<E>> taskList, List<? extends ExtendedSensor<?>> sensors) {
        ObjectOpenHashSet memoryTypes = new ObjectOpenHashSet();
        taskList.forEach(arg_0 -> this.lambda$createMemoryList$1((Set)memoryTypes, arg_0));
        sensors.forEach(arg_0 -> SmartBrainProvider.lambda$createMemoryList$2((Set)memoryTypes, arg_0));
        return ImmutableList.copyOf((Collection)memoryTypes);
    }

    private void collectMemoriesFromTask(Set<MemoryModuleType<?>> memories, Behavior<?> behaviour) {
        if (behaviour instanceof GateBehavior) {
            GateBehavior gateBehaviour = (GateBehavior)behaviour;
            gateBehaviour.f_22871_.m_147932_().forEach(subBehaviour -> this.collectMemoriesFromTask(memories, (Behavior<?>)subBehaviour));
        } else if (behaviour instanceof GroupBehaviour) {
            GroupBehaviour groupBehaviour = (GroupBehaviour)behaviour;
            groupBehaviour.getBehaviours().forEachRemaining(subBehaviour -> this.collectMemoriesFromTask(memories, (Behavior<?>)subBehaviour));
        } else {
            memories.addAll(behaviour.f_22522_.keySet());
        }
    }

    private List<BrainActivityGroup<E>> compileTasks() {
        ObjectArrayList tasks = new ObjectArrayList();
        BrainActivityGroup activityGroup = ((SmartBrainOwner)this.owner).getCoreTasks();
        if (!activityGroup.getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getIdleTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        if (!(activityGroup = ((SmartBrainOwner)this.owner).getFightTasks()).getBehaviours().isEmpty()) {
            tasks.add(activityGroup);
        }
        tasks.addAll(((SmartBrainOwner)this.owner).getAdditionalTasks().values());
        return tasks;
    }

    private void finaliseBrain(SmartBrain<E> brain) {
        brain.m_21930_(((SmartBrainOwner)this.owner).getAlwaysRunningActivities());
        brain.m_21944_(((SmartBrainOwner)this.owner).getDefaultActivity());
        brain.m_21962_();
        brain.setSchedule(((SmartBrainOwner)this.owner).getSchedule());
        ((SmartBrainOwner)this.owner).handleAdditionalBrainSetup(brain);
    }

    @Deprecated(forRemoval=true)
    protected void addActivity(SmartBrain<E> brain, Activity activity, BrainActivityGroup<E> activityGroup) {
        brain.f_21847_.put(activity, activityGroup.getActivityStartMemoryConditions());
        if (!activityGroup.getWipedMemoriesOnFinish().isEmpty()) {
            brain.f_21848_.put(activity, activityGroup.getWipedMemoriesOnFinish());
        }
        for (Pair pair : activityGroup.pairBehaviourPriorities()) {
            brain.addBehaviour((Integer)pair.getFirst(), activity, (Behavior)pair.getSecond());
        }
    }

    private static /* synthetic */ void lambda$createMemoryList$2(Set memoryTypes, ExtendedSensor sensor) {
        memoryTypes.addAll(sensor.memoriesUsed());
    }

    private /* synthetic */ void lambda$createMemoryList$1(Set memoryTypes, BrainActivityGroup activityGroup) {
        activityGroup.getBehaviours().forEach(behavior -> this.collectMemoriesFromTask(memoryTypes, (Behavior<?>)behavior));
    }
}

