/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.wall.paper;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartCaseJson;
import com.ldtteam.datagenerators.blockstate.multipart.MultipartWhenJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import org.jetbrains.annotations.NotNull;

public class PaperwallBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public PaperwallBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getPaperWall());
    }

    private void createBlockstateFile(CachedOutput cache, PaperWallBlock paperWallBlock) throws IOException {
        if (paperWallBlock.getRegistryName() == null) {
            return;
        }
        ArrayList cases = Lists.newArrayList();
        cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/paperwalls/blockpaperwall_post")), null));
        for (Direction possibleValue : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/paperwalls/blockpaperwall_" + possibleValue.name().toLowerCase(Locale.ROOT) + "_side")), new MultipartWhenJson(possibleValue.m_122433_().toLowerCase(Locale.ROOT), "true")));
            cases.add(new MultipartCaseJson(new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/paperwalls/blockpaperwall_off_" + possibleValue.name().toLowerCase(Locale.ROOT) + "_side")), new MultipartWhenJson(possibleValue.m_122433_().toLowerCase(Locale.ROOT), "false")));
        }
        BlockstateJson blockstate = new BlockstateJson((List)cases);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(paperWallBlock.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Paperwall BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case WEST: {
                return 270;
            }
            case SOUTH: {
                return 180;
            }
            case EAST: 
        }
        return 90;
    }
}

