/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.pillar;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.models.ModelDisplayPositionJson;
import com.ldtteam.datagenerators.models.ModelDisplayPositionsEnum;
import com.ldtteam.datagenerators.models.XYZDoubleListJson;
import com.ldtteam.datagenerators.models.XYZIntListJson;
import com.ldtteam.datagenerators.models.item.ItemModelJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.PillarBlock;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import org.jetbrains.annotations.NotNull;

public class PillarItemModelProvider
implements DataProvider {
    private final DataGenerator generator;

    public PillarItemModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        for (PillarBlock pillar : ModBlocks.getInstance().getPillars()) {
            ItemModelJson modelJson = new ItemModelJson();
            modelJson.setDisplay(this.getDisplay());
            String name = pillar.getRegistryName().m_135815_();
            String modelLocation = "domum_ornamentum:block/pillars/" + name + "/" + PillarShapeType.FULL_PILLAR.name().toLowerCase(Locale.ROOT);
            modelJson.setParent(modelLocation);
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)modelJson), (Path)this.generator.m_123916_().resolve("assets/domum_ornamentum//models/item/").resolve(name + ".json"));
        }
    }

    private Map<ModelDisplayPositionsEnum, ModelDisplayPositionJson> getDisplay() {
        HashMap<ModelDisplayPositionsEnum, ModelDisplayPositionJson> display = new HashMap<ModelDisplayPositionsEnum, ModelDisplayPositionJson>();
        XYZIntListJson guiRotation = new XYZIntListJson(30, 225, 0);
        XYZDoubleListJson guiTranslation = new XYZDoubleListJson(0.0, 0.5, 0.0);
        XYZDoubleListJson guiScale = new XYZDoubleListJson(0.625, 0.625, 0.625);
        ModelDisplayPositionJson guiPosition = new ModelDisplayPositionJson(guiRotation, guiTranslation, guiScale);
        display.put(ModelDisplayPositionsEnum.GUI, guiPosition);
        XYZIntListJson thirdPersonRotation = new XYZIntListJson(75, 45, 0);
        XYZDoubleListJson thirdPersonTranslation = new XYZDoubleListJson(0.0, 2.5, 0.0);
        XYZDoubleListJson thirdPersonScale = new XYZDoubleListJson(0.375, 0.375, 0.375);
        ModelDisplayPositionJson thirdPersonPosition = new ModelDisplayPositionJson(thirdPersonRotation, thirdPersonTranslation, thirdPersonScale);
        display.put(ModelDisplayPositionsEnum.THIRD_PERSON_LEFT_HAND, thirdPersonPosition);
        display.put(ModelDisplayPositionsEnum.THIRD_PERSON_RIGHT_HAND, thirdPersonPosition);
        XYZIntListJson firstPersonRotation = new XYZIntListJson(0, 225, 0);
        XYZDoubleListJson firstPersonScale = new XYZDoubleListJson(0.4, 0.4, 0.4);
        ModelDisplayPositionJson firstPersonPosition = new ModelDisplayPositionJson(firstPersonRotation, null, firstPersonScale);
        display.put(ModelDisplayPositionsEnum.FIRST_PERSON_LEFT_HAND, firstPersonPosition);
        display.put(ModelDisplayPositionsEnum.FIRST_PERSON_RIGHT_HAND, firstPersonPosition);
        XYZDoubleListJson groundTranslation = new XYZDoubleListJson(0.0, 3.0, 0.0);
        XYZDoubleListJson groundScale = new XYZDoubleListJson(0.25, 0.25, 0.25);
        ModelDisplayPositionJson groundPosition = new ModelDisplayPositionJson(null, groundTranslation, groundScale);
        display.put(ModelDisplayPositionsEnum.GROUND, groundPosition);
        XYZDoubleListJson fixedScale = new XYZDoubleListJson(0.5, 0.5, 0.5);
        ModelDisplayPositionJson fixedPosition = new ModelDisplayPositionJson(null, null, fixedScale);
        display.put(ModelDisplayPositionsEnum.FIXED, fixedPosition);
        XYZDoubleListJson headScale = new XYZDoubleListJson(1.03, 1.03, 1.03);
        ModelDisplayPositionJson headPosition = new ModelDisplayPositionJson(null, null, headScale);
        display.put(ModelDisplayPositionsEnum.HEAD, headPosition);
        return display;
    }

    @NotNull
    public String m_6055_() {
        return "Pillar Item Model Provider";
    }
}

