/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlockTrapdoor;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.FancyTrapdoorType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyTrapdoorBlock
extends AbstractBlockTrapdoor<FancyTrapdoorBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final EnumProperty<FancyTrapdoorType> TYPE = EnumProperty.m_61587_((String)"type", FancyTrapdoorType.class);
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("minecraft:block/oak_planks"), ModTags.FANCY_TRAPDOORS_MATERIALS, Blocks.f_50705_)).add((Object)new SimpleRetexturableComponent(new ResourceLocation("minecraft:block/acacia_planks"), ModTags.FANCY_TRAPDOORS_MATERIALS, Blocks.f_50744_)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public FancyTrapdoorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(3.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_((state, blockGetter, pos, type) -> false));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)FancyTrapdoorType.FULL)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            for (FancyTrapdoorType trapdoorType : FancyTrapdoorType.values()) {
                ItemStack result = new ItemStack((ItemLike)this);
                result.m_41784_().m_128359_("type", trapdoorType.toString().toUpperCase());
                this.fillItemGroupCache.add(result);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        String type = stack.m_41784_().m_128461_("type");
        worldIn.m_7731_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)FancyTrapdoorType.valueOf(type.toUpperCase()))), 3);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder, (s, e) -> {
            s.m_41784_().m_128359_("type", ((FancyTrapdoorType)((Object)((Object)e.m_58900_().m_61143_(TYPE)))).toString().toUpperCase());
            return s;
        });
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos, (s, e) -> {
            s.m_41784_().m_128359_("type", ((FancyTrapdoorType)((Object)((Object)e.m_58900_().m_61143_(TYPE)))).toString().toUpperCase());
            return s;
        });
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.getExplosionResistance(state, level, pos, explosion);
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.m_5880_(block.m_49966_(), player, level, pos);
        }
        return super.m_5880_(state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        MateriallyTexturedBlockEntity mtbe;
        Block block;
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof MateriallyTexturedBlockEntity && (block = (mtbe = (MateriallyTexturedBlockEntity)be).getTextureData().getTexturedComponents().get(COMPONENTS.get(0).getId())) != null) {
            return block.getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        ArrayList<FinishedRecipe> recipes = new ArrayList<FinishedRecipe>();
        for (final FancyTrapdoorType value : FancyTrapdoorType.values()) {
            recipes.add(new FinishedRecipe(){

                public void m_7917_(@NotNull JsonObject jsonObject) {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("type", value.toString().toUpperCase());
                    jsonObject.addProperty("block", Objects.requireNonNull(FancyTrapdoorBlock.this.getRegistryName(FancyTrapdoorBlock.this.getBlock())).toString());
                    jsonObject.addProperty("nbt", tag.toString());
                }

                @NotNull
                public ResourceLocation m_6445_() {
                    return new ResourceLocation(Objects.requireNonNull(FancyTrapdoorBlock.this.getRegistryName(FancyTrapdoorBlock.this.getBlock())).toString() + "_" + value.m_7912_());
                }

                @NotNull
                public RecipeSerializer<?> m_6637_() {
                    return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
                }

                @Nullable
                public JsonObject m_5860_() {
                    return null;
                }

                @Nullable
                public ResourceLocation m_6448_() {
                    return null;
                }
            });
        }
        return recipes;
    }
}

