/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.trunk;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.material.Material;

public abstract class BaseGenesisHookedTrunkPlacer
extends TrunkPlacer {
    public BaseGenesisHookedTrunkPlacer(int height, int heightRandA, int heightRandB) {
        super(height, heightRandA, heightRandB);
    }

    public List<FoliagePlacer.FoliageAttachment> placeVerticalTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, BlockStateProvider trunkProvider) {
        ArrayList list = Lists.newArrayList();
        int radius = 0;
        int cutoff = height % 2 == 1 ? height : height - 1;
        for (int i = 0; i < height + 1; ++i) {
            if (i < height) {
                this.placeTrunk(level, blockSetter, random, pos.m_6630_(i), trunkProvider);
            }
            if (i > 1 && i < cutoff) {
                radius = i % 2 + 1;
            }
            if (i > cutoff) {
                radius = 1;
            }
            if (i >= height) {
                radius = 0;
            }
            list.add(new FoliagePlacer.FoliageAttachment(pos.m_6630_(i), radius, false));
        }
        return list;
    }

    public List<FoliagePlacer.FoliageAttachment> placeBranches(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int height, BlockPos pos, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        int bound = 3;
        float f = 0.0f;
        for (int i = random.m_188503_(2) + 3; i < height - 2; i += random.m_188503_(2) + 1) {
            BlockPos blockpos;
            int l;
            int j = (int)Mth.m_14089_((float)f);
            int k = (int)Mth.m_14031_((float)f);
            int offset = random.m_188503_(bound) + 2;
            for (l = 0; l < offset; ++l) {
                blockpos = pos.m_7918_(j * l, i, k * l);
                this.placeBranch(level, blockSetter, random, blockpos, config);
                list.add(new FoliagePlacer.FoliageAttachment(blockpos.m_7494_(), 0, false));
                list.add(new FoliagePlacer.FoliageAttachment(blockpos, 1, false));
                list.add(new FoliagePlacer.FoliageAttachment(blockpos.m_7495_(), 0, false));
            }
            for (l = 1; l < 4; ++l) {
                if (l == 2) {
                    ++offset;
                }
                if (l <= 2) {
                    list.add(new FoliagePlacer.FoliageAttachment(pos.m_7918_(j * (offset - 1) - k, i + l, k * (offset - 1) - j), 0, false));
                    list.add(new FoliagePlacer.FoliageAttachment(pos.m_7918_(j * (offset - 1) + k, i + l, k * (offset - 1) + j), 0, false));
                }
                blockpos = pos.m_7918_(j * offset, i + l, k * offset);
                this.placeBranch(level, blockSetter, random, blockpos, config);
                list.add(new FoliagePlacer.FoliageAttachment(blockpos, 1, false));
                list.add(new FoliagePlacer.FoliageAttachment(blockpos.m_7494_(), 0, false));
            }
            if (bound <= 1 || (double)(f += 1.5707964f) % 0.5 != 0.0) continue;
            bound -= random.m_188503_(2);
        }
        return list;
    }

    protected boolean placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, BlockStateProvider trunkProvider) {
        return this.placeTrunk(level, blockSetter, random, pos, Function.identity(), trunkProvider);
    }

    protected boolean placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, Function<BlockState, BlockState> propertySetter, BlockStateProvider trunkProvider) {
        if (this.m_213554_(level, pos)) {
            blockSetter.accept(pos, propertySetter.apply(trunkProvider.m_213972_(random, pos)));
            return true;
        }
        return false;
    }

    protected boolean placeBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        return this.placeBranch(level, blockSetter, random, pos, config, Function.identity());
    }

    protected boolean placeBranch(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, Function<BlockState, BlockState> propertySetter) {
        if (this.validBranchPos(level, pos)) {
            blockSetter.accept(pos, propertySetter.apply(config.f_68185_.m_213972_(random, pos)));
            return true;
        }
        return false;
    }

    protected boolean validBranchPos(LevelSimulatedReader level, BlockPos pos) {
        return TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos) || BaseGenesisHookedTrunkPlacer.isReplaceablePlant(level, pos) || TreeFeature.m_67282_((LevelSimulatedReader)level, (BlockPos)pos) || this.isTrunk(level, pos);
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader level, BlockPos pos) {
        return level.m_7433_(pos, state -> {
            Material material = state.m_60767_();
            return material == Material.f_76302_ || material == Material.f_76304_ || material == Material.f_76303_;
        });
    }

    public abstract boolean isTrunk(LevelSimulatedReader var1, BlockPos var2);
}

