/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.tree.decorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.zepalesque.redux.world.tree.decorator.ReduxTreeDecorators;

public class PatchTreeDecorator
extends TreeDecorator {
    public static final Codec<PatchTreeDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.f_68747_.fieldOf("provider").forGetter(patchTreeDecorator -> patchTreeDecorator.provider), (App)ExtraCodecs.f_144628_.fieldOf("xz_spread").orElse((Object)7).forGetter(patchTreeDecorator -> patchTreeDecorator.xzSpread), (App)ExtraCodecs.f_144628_.fieldOf("y_spread").orElse((Object)3).forGetter(patchTreeDecorator -> patchTreeDecorator.ySpread), (App)ExtraCodecs.f_144629_.fieldOf("tries").orElse((Object)128).forGetter(patchTreeDecorator -> patchTreeDecorator.tries)).apply((Applicative)builder, PatchTreeDecorator::new));
    public final BlockStateProvider provider;
    public final int tries;
    public final int xzSpread;
    public final int ySpread;

    public PatchTreeDecorator(BlockStateProvider provider, int xzSpread, int ySpread, int tries) {
        this.provider = provider;
        this.tries = tries;
        this.xzSpread = xzSpread;
        this.ySpread = ySpread;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)ReduxTreeDecorators.PATCH.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        ObjectArrayList logPositions = context.m_226068_();
        if (!logPositions.isEmpty()) {
            int i = ((BlockPos)logPositions.get(0)).m_123342_();
            logPositions.stream().filter(logs -> logs.m_123342_() == i).forEach(logPos -> this.place(this.xzSpread, this.ySpread, this.tries, (BlockPos)logPos, context));
        }
    }

    public void place(int xzSpread, int ySpread, int tries, BlockPos origin, TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        LevelSimulatedReader level = context.m_226058_();
        boolean i = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = xzSpread + 1;
        int k = ySpread + 1;
        for (int l = 0; l < tries; ++l) {
            blockpos$mutableblockpos.m_122154_((Vec3i)origin, random.m_188503_(j) - random.m_188503_(j), random.m_188503_(k) - random.m_188503_(k), random.m_188503_(j) - random.m_188503_(j));
            this.placeBlockAt(context, level, random, (BlockPos)blockpos$mutableblockpos);
        }
    }

    private void placeBlockAt(TreeDecorator.Context context, LevelSimulatedReader pLevel, RandomSource pRandom, BlockPos pPos) {
        if (context.m_226059_(pPos)) {
            context.m_226061_(pPos, this.provider.m_213972_(pRandom, pPos));
        }
    }
}

