/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class UpwardVineFeature
extends Feature<Config> {
    public UpwardVineFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = context.m_159774_();
        if (!UpwardVineFeature.canPlaceHere((LevelAccessor)worldgenlevel, blockpos = context.m_159777_())) {
            return false;
        }
        RandomSource rand = context.m_225041_();
        Config config = (Config)context.m_159778_();
        int height = config.length.m_214085_(rand);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < height; ++i) {
            boolean isLast;
            mutable.m_122154_((Vec3i)blockpos, 0, i, 0);
            boolean bl = isLast = !UpwardVineFeature.validBlockPos((LevelAccessor)worldgenlevel, mutable.m_7494_()) || i == height - 1;
            if (isLast) {
                worldgenlevel.m_7731_((BlockPos)mutable, config.head.m_213972_(rand, (BlockPos)mutable), 3);
                break;
            }
            worldgenlevel.m_7731_((BlockPos)mutable, config.vine.m_213972_(rand, (BlockPos)mutable), 3);
        }
        return true;
    }

    private static boolean canPlaceHere(LevelAccessor level, BlockPos pos) {
        if (!UpwardVineFeature.validBlockPos(level, pos)) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        return !level.m_7433_(below, state -> !state.m_204336_(BlockTags.f_144274_));
    }

    private static boolean validBlockPos(LevelAccessor level, BlockPos pos) {
        return level.m_7433_(pos, state -> state.m_60795_() || state.m_60767_().m_76336_());
    }

    public record Config(BlockStateProvider vine, BlockStateProvider head, IntProvider length) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(p_191375_ -> p_191375_.group((App)BlockStateProvider.f_68747_.fieldOf("vine_plant").forGetter(Config::vine), (App)BlockStateProvider.f_68747_.fieldOf("vine_head").forGetter(Config::head), (App)IntProvider.f_146533_.fieldOf("length").forGetter(Config::length)).apply((Applicative)p_191375_, Config::new));
    }
}

