/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.player;

import com.aetherteam.aether.item.EquipmentUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.particle.ReduxParticleTypes;
import net.zepalesque.redux.entity.projectile.VolatileFireCrystal;
import net.zepalesque.redux.item.ReduxItems;

public class AbilityUtil {
    public static void doDoubleJumpMovement(LivingEntity entity) {
        double upJump = 0.35 + (EquipmentUtil.hasCurio((LivingEntity)entity, (Item)((Item)ReduxItems.AIRBOUND_CAPE.get())) && EquipmentUtil.getCurios((LivingEntity)entity, (Item)((Item)ReduxItems.AIRBOUND_CAPE.get())).size() == 2 ? 0.15 : 0.1);
        double xDelta = entity.m_20184_().m_7096_() * 1.4;
        double yDelta = upJump;
        double zDelta = entity.m_20184_().m_7094_() * 1.4;
        entity.m_20334_(xDelta, yDelta, zDelta);
        AbilityUtil.spawnDoubleJumpParticles(entity.f_19853_, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, 1.5, 12);
        entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.BOOST_JUMP.get(), SoundSource.PLAYERS, 0.4f, 0.9f + entity.f_19853_.f_46441_.m_188501_() * 0.2f);
    }

    public static void spawnDoubleJumpParticles(Level level, double x, double y, double z, double radius, int quantity) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < quantity; ++i) {
            double x2 = x + random.m_188500_() * radius - radius * 0.5;
            double y2 = y + random.m_188500_() * 0.4;
            double z2 = z + random.m_188500_() * radius - radius * 0.5;
            level.m_7106_((ParticleOptions)ReduxParticleTypes.SHINY_CLOUD, x2, y2, z2, 0.0, random.m_188500_() * 0.03, 0.0);
        }
    }

    public static void shootFireballs(LivingEntity entity) {
        if (EquipmentUtil.hasCurio((LivingEntity)entity, (Item)((Item)ReduxItems.SOLAR_EMBLEM.get()))) {
            if (EquipmentUtil.getCurios((LivingEntity)entity, (Item)((Item)ReduxItems.SOLAR_EMBLEM.get())).size() == 1) {
                float offset = 0.0f;
                float rotation = Mth.m_14177_((float)(entity.m_146908_() + offset));
                VolatileFireCrystal crystal = new VolatileFireCrystal(entity.f_19853_, (Entity)entity);
                crystal.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
                crystal.m_37251_((Entity)entity, entity.m_146909_(), rotation, 0.0f, 1.0f, 1.0f);
                crystal.m_5602_((Entity)entity);
                if (!entity.f_19853_.f_46443_) {
                    entity.f_19853_.m_7967_((Entity)crystal);
                    entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.FIREBALL_SHOOT.get(), SoundSource.PLAYERS, 0.4f, 0.9f + entity.f_19853_.f_46441_.m_188501_() * 0.2f);
                }
            } else {
                float offset = 2.0f;
                float rotation = Mth.m_14177_((float)(entity.m_146908_() + offset));
                VolatileFireCrystal crystal = new VolatileFireCrystal(entity.f_19853_, (Entity)entity);
                crystal.m_146884_(AbilityUtil.getSidedPoition(entity, HumanoidArm.RIGHT));
                crystal.m_37251_((Entity)entity, entity.m_146909_(), rotation, 0.0f, 1.0f, 1.0f);
                crystal.m_5602_((Entity)entity);
                if (!entity.f_19853_.f_46443_) {
                    entity.f_19853_.m_7967_((Entity)crystal);
                    entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.FIREBALL_SHOOT.get(), SoundSource.PLAYERS, 0.4f, 0.9f + entity.f_19853_.f_46441_.m_188501_() * 0.2f);
                }
                float offset1 = -2.0f;
                float rotation1 = Mth.m_14177_((float)(entity.m_146908_() + offset1));
                VolatileFireCrystal crystal1 = new VolatileFireCrystal(entity.f_19853_, (Entity)entity);
                crystal1.m_146884_(AbilityUtil.getSidedPoition(entity, HumanoidArm.LEFT));
                crystal1.m_37251_((Entity)entity, entity.m_146909_(), rotation1, 0.0f, 1.0f, 1.0f);
                crystal1.m_5602_((Entity)entity);
                if (!entity.f_19853_.f_46443_) {
                    entity.f_19853_.m_7967_((Entity)crystal1);
                    entity.f_19853_.m_6263_(null, entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_, (SoundEvent)ReduxSoundEvents.FIREBALL_SHOOT.get(), SoundSource.PLAYERS, 0.4f, 0.9f + entity.f_19853_.f_46441_.m_188501_() * 0.2f);
                }
            }
            entity.m_21011_(InteractionHand.MAIN_HAND, true);
        }
    }

    public static Vec3 getSidedPoition(LivingEntity owner, HumanoidArm side) {
        double yaw = owner.m_146908_();
        yaw = side == HumanoidArm.RIGHT ? (yaw -= 90.0) : (yaw += 90.0);
        double targetX = owner.m_20185_() + Math.sin(yaw /= -57.29577951308232) * 1.05;
        double targetY = owner.m_20186_() + 1.0;
        double targetZ = owner.m_20189_() + Math.cos(yaw) * 1.05;
        return new Vec3(targetX, targetY, targetZ);
    }
}

