/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.condition.AbstractCondition;

public class DataRecipeCondition
implements ICondition {
    private static final ResourceLocation NAME = Redux.locate("data_recipe_condition");
    private final AbstractCondition condition;

    public DataRecipeCondition(AbstractCondition pCondition) {
        this.condition = pCondition;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        if (this.condition != null) {
            return this.condition.isConditionMet();
        }
        return true;
    }

    public String toString() {
        return "data_condition(\"" + (this.condition != null ? this.condition.text() : "null") + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<DataRecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, DataRecipeCondition value) {
            DataResult result = AbstractCondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value.condition);
            result.resultOrPartial(errorMessage -> Redux.LOGGER.warn("Could not write DataRecipeCondition with id {} - error: {}", (Object)this.getID(), errorMessage)).ifPresent(jsonElement -> json.add("data_recipe_condition", jsonElement));
        }

        public DataRecipeCondition read(JsonObject json) {
            JsonElement element = json.get("data_recipe_condition");
            Optional optional = AbstractCondition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(errorMessage -> Redux.LOGGER.warn("Could not parse DataRecipeCondition from json with id {} - error: {}", (Object)this.getID(), errorMessage));
            if (optional.isPresent()) {
                return new DataRecipeCondition((AbstractCondition)optional.get());
            }
            throw new JsonSyntaxException("Failed to parse data condition json!");
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

